/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SitePatterns;
import dr.evolution.datatype.DataType;
import dr.evolution.util.Taxon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TaxaFilteredSitePatterns
implements PatternList {
    private PatternList original;
    private String id = null;
    private List<Taxon> taxonList;
    private int[] mapOriginalToFiltered;
    private int[] mapFilteredToOriginal;

    public TaxaFilteredSitePatterns(SitePatterns sitePatterns, List<Taxon> list, List<Taxon> list2) {
        int n;
        Taxon taxon2;
        this.original = sitePatterns;
        this.taxonList = list == null ? sitePatterns.asList() : list;
        if (list2 != null) {
            for (Taxon taxon2 : list2) {
                if (this.taxonList.contains(taxon2)) {
                    this.taxonList.remove(taxon2);
                    continue;
                }
                throw new IllegalArgumentException("Taxon '" + taxon2.getId() + "' is not in current taxon list");
            }
        }
        this.mapOriginalToFiltered = new int[sitePatterns.getTaxonCount()];
        this.mapFilteredToOriginal = new int[this.getTaxonCount()];
        for (n = 0; n < this.mapFilteredToOriginal.length; ++n) {
            taxon2 = this.taxonList.get(n);
            this.mapFilteredToOriginal[n] = sitePatterns.getTaxonIndex(taxon2);
        }
        for (n = 0; n < this.mapOriginalToFiltered.length; ++n) {
            taxon2 = sitePatterns.getTaxon(n);
            this.mapOriginalToFiltered[n] = this.taxonList.contains(taxon2) ? this.taxonList.indexOf(taxon2) : -1;
        }
    }

    @Override
    public int getPatternCount() {
        return this.original.getPatternCount();
    }

    @Override
    public int getStateCount() {
        return this.original.getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.original.getPatternLength();
    }

    @Override
    public int[] getPattern(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getPatternState(int n, int n2) {
        int n3 = this.mapFilteredToOriginal[n];
        return this.original.getPatternState(n3, n2);
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getPatternWeight(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getPatternWeights() {
        return this.original.getPatternWeights();
    }

    @Override
    public int getPatternIndex(int n) {
        return -1;
    }

    @Override
    public DataType getDataType() {
        return this.original.getDataType();
    }

    @Override
    public double[] getStateFrequencies() {
        return this.original.getStateFrequencies();
    }

    @Override
    public boolean areUnique() {
        return this.original.areUnique();
    }

    @Override
    public boolean areUncertain() {
        return this.original.areUncertain();
    }

    @Override
    public int getTaxonCount() {
        return this.taxonList.size();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.taxonList.get(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.taxonList.get(n).getId();
    }

    @Override
    public int getTaxonIndex(String string) {
        for (int i = 0; i < this.taxonList.size(); ++i) {
            Taxon taxon = this.taxonList.get(i);
            if (!taxon.getId().equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public Iterator<Taxon> iterator() {
        throw new RuntimeException("Not yet implemented");
    }
}

