/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Clade
implements Comparable<Clade> {
    private final BitSet bits;
    private double height;
    private List<Double> heights;
    private final int size;

    public Clade(BitSet bitSet, double d) {
        this.bits = bitSet;
        this.height = d;
        this.size = bitSet.cardinality();
        this.heights = new ArrayList<Double>();
    }

    public BitSet getBits() {
        return this.bits;
    }

    public double getHeight() {
        return this.height;
    }

    public double getHeight(int n) {
        return this.heights.get(n);
    }

    public int getSampleCount() {
        return this.heights.size();
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public int compareTo(Clade clade) {
        int n = -1;
        int n2 = -1;
        BitSet bitSet = clade.getBits();
        while ((n = this.bits.nextSetBit(n + 1)) == (n2 = bitSet.nextSetBit(n2 + 1)) && n != -1) {
        }
        return n < n2 ? -1 : (n > n2 ? 1 : 0);
    }

    public boolean equals(Object object) {
        if (object instanceof Clade) {
            return this.equals((Clade)object);
        }
        return false;
    }

    public boolean equals(Clade clade) {
        if (this.size != clade.getSize()) {
            return false;
        }
        return this.compareTo(clade) == 0;
    }

    public String toString() {
        return this.bits.toString();
    }

    public int hashCode() {
        return this.bits.hashCode();
    }

    public void addHeight(double d) {
        this.heights.add(d);
        this.setHeight(d);
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public static Set<Clade> getCladeSet(Tree tree) {
        return new HashSet<Clade>(Clade.getCladeList(tree));
    }

    public static List<Clade> getCladeList(Tree tree) {
        ArrayList<Clade> arrayList = new ArrayList<Clade>();
        Clade.getClades(arrayList, tree, tree.getRoot());
        return arrayList;
    }

    private static BitSet getClades(List<Clade> list, Tree tree, NodeRef nodeRef) {
        BitSet bitSet = new BitSet();
        if (tree.isExternal(nodeRef)) {
            bitSet.set(nodeRef.getNumber());
        } else {
            bitSet.or(Clade.getClades(list, tree, tree.getChild(nodeRef, 0)));
            bitSet.or(Clade.getClades(list, tree, tree.getChild(nodeRef, 1)));
            list.add(new Clade(bitSet, tree.getNodeHeight(nodeRef)));
        }
        return bitSet;
    }
}

