/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.evomodel.branchmodel.lineagespecific.CountableRealizationsParameter;
import dr.evomodel.branchmodel.lineagespecific.DirichletProcessOperator;
import dr.evomodel.branchmodel.lineagespecific.DirichletProcessPrior;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DirichletProcessOperatorParser
extends AbstractXMLObjectParser {
    public static final String DIRICHLET_PROCESS_OPERATOR = "dpOperator";
    public static final String DATA_LOG_LIKELIHOOD = "dataLogLikelihood";
    public static final String MH_STEPS = "mhSteps";

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        DirichletProcessPrior dirichletProcessPrior = (DirichletProcessPrior)xMLObject.getChild(DirichletProcessPrior.class);
        Likelihood likelihood = (Likelihood)xMLObject.getElementFirstChild(DATA_LOG_LIKELIHOOD);
        Parameter parameter = (Parameter)xMLObject.getElementFirstChild("categories");
        CountableRealizationsParameter countableRealizationsParameter = (CountableRealizationsParameter)xMLObject.getChild(CountableRealizationsParameter.class);
        CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getChild(CompoundParameter.class);
        int n = xMLObject.getIntegerAttribute(MH_STEPS);
        double d = xMLObject.getDoubleAttribute("weight");
        return new DirichletProcessOperator(dirichletProcessPrior, parameter, compoundParameter, countableRealizationsParameter, likelihood, n, d);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{new ElementRule(DirichletProcessPrior.class, false), new ElementRule(CompoundParameter.class, false), new ElementRule(CountableRealizationsParameter.class, false), AttributeRule.newDoubleRule("weight")};
    }

    @Override
    public String getParserName() {
        return DIRICHLET_PROCESS_OPERATOR;
    }

    @Override
    public String getParserDescription() {
        return DIRICHLET_PROCESS_OPERATOR;
    }

    @Override
    public Class getReturnType() {
        return DirichletProcessOperator.class;
    }
}

