/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import beagle.Beagle;
import beagle.BeagleBenchmarkFlag;
import beagle.BeagleFactory;
import beagle.BeagleFlag;
import beagle.BenchmarkedResourceDetails;
import beagle.InstanceDetails;
import beagle.ResourceDetails;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.UncertainSiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.evomodel.treedatalikelihood.BeagleFunctionality;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treedatalikelihood.DataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.EvolutionaryProcessDelegate;
import dr.evomodel.treedatalikelihood.HomogenousSubstitutionModelDelegate;
import dr.evomodel.treedatalikelihood.PreOrderSettings;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.RateRescalingScheme;
import dr.evomodel.treedatalikelihood.SubstitutionModelDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class BeagleDataLikelihoodDelegate
extends AbstractModel
implements DataLikelihoodDelegate {
    private static final boolean COUNT_CALCULATIONS = true;
    private static final boolean RESCALING_OFF = false;
    private static final boolean DEBUG = false;
    private static final String RESOURCE_AUTO_PROPERTY = "beagle.resource.auto";
    private static final String RESOURCE_ORDER_PROPERTY = "beagle.resource.order";
    private static final String PREFERRED_FLAGS_PROPERTY = "beagle.preferred.flags";
    private static final String REQUIRED_FLAGS_PROPERTY = "beagle.required.flags";
    private static final String SCALING_PROPERTY = "beagle.scaling";
    private static final String RESCALE_FREQUENCY_PROPERTY = "beagle.rescale";
    private static final String DELAY_SCALING_PROPERTY = "beagle.delay.scaling";
    private static final String EXTRA_BUFFER_COUNT_PROPERTY = "beagle.extra.buffer.count";
    private static final String FORCE_VECTORIZATION = "beagle.force.vectorization";
    private static final String THREAD_COUNT = "beagle.thread.count";
    private static final PartialsRescalingScheme DEFAULT_RESCALING_SCHEME = PartialsRescalingScheme.DYNAMIC;
    public static int instanceCount = 0;
    private static List<Integer> resourceOrder = null;
    private static List<Long> preferredOrder = null;
    private static List<Long> requiredOrder = null;
    private static List<String> scalingOrder = null;
    private static List<Integer> extraBufferOrder = null;
    private static final int RESCALE_FREQUENCY = 10000;
    private static final int RESCALE_TIMES = 1;
    private long totalMatrixUpdateCount = 0L;
    private long totalPartialsUpdateCount = 0L;
    private long totalEvaluationCount = 0L;
    private boolean releaseSingleton = true;
    private final int nodeCount;
    private final int tipCount;
    private final int internalNodeCount;
    private final int[] branchUpdateIndices;
    private final double[] branchLengths;
    private int[] scaleBufferIndices;
    private int[] storedScaleBufferIndices;
    private final int[] operations;
    private boolean flip = true;
    private final BufferIndexHelper partialBufferHelper;
    private final BufferIndexHelper scaleBufferHelper;
    private PartialsRescalingScheme rescalingScheme;
    private int rescalingFrequency = 10000;
    private boolean delayRescalingUntilUnderflow = true;
    private boolean useScaleFactors = false;
    private boolean useAutoScaling = false;
    private boolean recomputeScaleFactors = false;
    private boolean everUnderflowed = false;
    private int rescalingCount = 0;
    private int rescalingCountInner = 0;
    private int threadCount = -1;
    private long instanceFlags;
    private boolean firstRescaleAttempt = false;
    private int rescalingMessageCount = 0;
    private int underflowHandling = 0;
    private final PatternList patternList;
    private final DataType dataType;
    private double[] patternWeights;
    private double[] storedPatternWeights;
    private Parameter siteAssignInd;
    private Parameter partitionCat;
    private boolean isRestored;
    private final int patternCount;
    private final int stateCount;
    private final BranchModel branchModel;
    private final EvolutionaryProcessDelegate evolutionaryProcessDelegate;
    private final SiteRateModel siteRateModel;
    private double[] patternLogLikelihoods = null;
    private final int categoryCount;
    private double[] tipPartials;
    private int[] tipStates;
    private final Beagle beagle;
    private boolean updateSubstitutionModel;
    private boolean updateSiteModel;
    private boolean updateRootFrequency;
    private boolean initialEvaluation = true;
    private PreOrderSettings settings;
    private boolean useAmbiguities;
    private boolean prefersGPU;
    private static boolean USE_CACHED_EXCEPTION = true;
    private DataLikelihoodDelegate.LikelihoodUnderflowException cachedException = null;

    public BeagleDataLikelihoodDelegate(Tree tree, PatternList patternList, BranchModel branchModel, SiteRateModel siteRateModel, boolean bl, boolean bl2, PartialsRescalingScheme partialsRescalingScheme, boolean bl3, PreOrderSettings preOrderSettings, Parameter parameter, Parameter parameter2) {
        super("BeagleDataLikelihoodDelegate");
        int n;
        int n2;
        int n3;
        int n4;
        Logger logger = Logger.getLogger("dr.evomodel");
        logger.info("\nCreating BEAGLE DataLikelihood Delegate");
        this.setId(patternList.getId());
        this.dataType = patternList.getDataType();
        this.patternList = patternList;
        this.patternCount = patternList.getPatternCount();
        this.stateCount = this.dataType.getStateCount();
        if (parameter != null) {
            this.partitionCat = parameter2;
            this.siteAssignInd = parameter;
            this.addVariable(parameter);
        }
        if (this.stateCount != (n4 = branchModel.getRootFrequencyModel().getFrequencyCount())) {
            throw new IllegalArgumentException("Pattern state count (" + this.stateCount + ") does not match substitution model state count (" + n4 + ")");
        }
        if (parameter == null) {
            this.patternWeights = patternList.getPatternWeights();
        } else {
            this.patternWeights = new double[this.patternCount];
            for (n3 = 0; n3 < parameter.getSize(); ++n3) {
                n2 = (int)parameter.getParameterValue(n3);
                if ((int)parameter2.getParameterValue(0) != n2) continue;
                n = patternList.getPatternIndex(n3);
                this.patternWeights[n] = this.patternWeights[n] + 1.0;
            }
            this.storedPatternWeights = new double[this.patternWeights.length];
        }
        this.branchModel = branchModel;
        this.addModel(this.branchModel);
        this.siteRateModel = siteRateModel;
        this.addModel(this.siteRateModel);
        this.categoryCount = this.siteRateModel.getCategoryCount();
        this.nodeCount = tree.getNodeCount();
        this.tipCount = tree.getExternalNodeCount();
        this.internalNodeCount = this.nodeCount - this.tipCount;
        this.branchUpdateIndices = new int[this.nodeCount];
        this.branchLengths = new double[this.nodeCount];
        this.scaleBufferIndices = new int[this.internalNodeCount];
        this.storedScaleBufferIndices = new int[this.internalNodeCount];
        this.operations = new int[this.internalNodeCount * 7];
        this.firstRescaleAttempt = true;
        this.isRestored = false;
        this.settings = preOrderSettings;
        try {
            Object object;
            Object object2;
            String string;
            String string2;
            String string3;
            String string4;
            n3 = this.tipCount;
            if (bl) {
                n3 = 0;
            }
            this.partialBufferHelper = new BufferIndexHelper(this.nodeCount, this.tipCount);
            this.scaleBufferHelper = new BufferIndexHelper(this.getSingleScaleBufferCount(), 0);
            if (extraBufferOrder == null) {
                extraBufferOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(EXTRA_BUFFER_COUNT_PROPERTY);
            }
            n2 = 100;
            if (extraBufferOrder.size() > 0) {
                n2 = extraBufferOrder.get(instanceCount % extraBufferOrder.size());
            }
            this.evolutionaryProcessDelegate = preOrderSettings.branchInfinitesimalDerivative ? new SubstitutionModelDelegate(tree, branchModel, 0, n2, preOrderSettings) : (branchModel.getSubstitutionModels().size() == 1 ? new HomogenousSubstitutionModelDelegate(tree, branchModel) : new SubstitutionModelDelegate(tree, branchModel, 0, n2, preOrderSettings));
            n = this.partialBufferHelper.getBufferCount();
            int n5 = this.scaleBufferHelper.getBufferCount();
            int n6 = this.evolutionaryProcessDelegate.getMatrixBufferCount();
            if (preOrderSettings.usePreOrder) {
                n += this.nodeCount;
                n5 += this.nodeCount - 1;
                n6 += this.evolutionaryProcessDelegate.getCachedMatrixBufferCount(preOrderSettings);
            }
            if (resourceOrder == null) {
                resourceOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(RESOURCE_ORDER_PROPERTY);
            }
            if (preferredOrder == null) {
                preferredOrder = BeagleFunctionality.parseSystemPropertyLongArray(PREFERRED_FLAGS_PROPERTY);
            }
            if (requiredOrder == null) {
                requiredOrder = BeagleFunctionality.parseSystemPropertyLongArray(REQUIRED_FLAGS_PROPERTY);
            }
            if (scalingOrder == null) {
                scalingOrder = BeagleFunctionality.parseSystemPropertyStringArray(SCALING_PROPERTY);
            }
            this.rescalingScheme = partialsRescalingScheme;
            this.delayRescalingUntilUnderflow = bl3;
            this.prefersGPU = bl2;
            this.useAmbiguities = bl;
            int[] nArray = null;
            long l = 0L;
            long l2 = 0L;
            if (scalingOrder.size() > 0) {
                this.rescalingScheme = PartialsRescalingScheme.parseFromString(scalingOrder.get(instanceCount % scalingOrder.size()));
            }
            if (resourceOrder.size() > 0 && (nArray = new int[]{resourceOrder.get(instanceCount % resourceOrder.size()), 0})[0] > 0) {
                l |= BeagleFlag.PROCESSOR_GPU.getMask();
            }
            if (bl2) {
                l |= BeagleFlag.PROCESSOR_GPU.getMask();
            }
            if (preferredOrder.size() > 0) {
                l = preferredOrder.get(instanceCount % preferredOrder.size());
            }
            if (requiredOrder.size() > 0) {
                l2 = requiredOrder.get(instanceCount % requiredOrder.size());
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DEFAULT) {
                this.rescalingScheme = nArray != null && nArray[0] > true ? DEFAULT_RESCALING_SCHEME : DEFAULT_RESCALING_SCHEME;
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DELAYED) {
                this.delayRescalingUntilUnderflow = true;
                this.rescalingScheme = PartialsRescalingScheme.ALWAYS;
            }
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO) {
                l |= BeagleFlag.SCALING_AUTO.getMask();
                this.useAutoScaling = true;
            }
            if ((string4 = System.getProperty(RESCALE_FREQUENCY_PROPERTY)) != null) {
                this.rescalingFrequency = Integer.parseInt(string4);
                if (this.rescalingFrequency < 1) {
                    this.rescalingFrequency = 10000;
                }
            }
            if ((string3 = System.getProperty(DELAY_SCALING_PROPERTY)) != null) {
                this.delayRescalingUntilUnderflow = Boolean.parseBoolean(string3);
            }
            if (l == 0L && nArray == null && this.stateCount == 4 && patternList.getPatternCount() < 10000) {
                l |= BeagleFlag.PROCESSOR_CPU.getMask();
            }
            boolean bl4 = false;
            String string5 = System.getProperty(FORCE_VECTORIZATION);
            if (string5 != null) {
                bl4 = true;
            }
            if ((string2 = System.getProperty(THREAD_COUNT)) != null) {
                this.threadCount = Integer.parseInt(string2);
            }
            if (this.threadCount < 1) {
                l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.THREADING_NONE.getMask();
            } else {
                l &= BeagleFlag.THREADING_NONE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.THREADING_CPP.getMask();
            }
            if (BeagleFlag.VECTOR_SSE.isSet(l) && this.stateCount != 4 && !bl4 && !BeagleFunctionality.IS_ODD_STATE_SSE_FIXED()) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.VECTOR_NONE.getMask();
                if (this.stateCount > 4 && this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                    this.rescalingScheme = PartialsRescalingScheme.DELAYED;
                }
            }
            if (this.evolutionaryProcessDelegate.canReturnComplexDiagonalization()) {
                l2 |= BeagleFlag.EIGEN_COMPLEX.getMask();
            }
            if (nArray == null && (BeagleFlag.PROCESSOR_GPU.isSet(l) || BeagleFlag.FRAMEWORK_CUDA.isSet(l) || BeagleFlag.FRAMEWORK_OPENCL.isSet(l)) || nArray != null && nArray[0] > 0) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (preOrderSettings.usePreOrder && this.stateCount > 4) {
                l2 |= BeagleFlag.PREORDER_TRANSPOSE_AUTO.getMask();
            }
            if (Boolean.parseBoolean(string = System.getProperty(RESOURCE_AUTO_PROPERTY))) {
                long l3 = 0L;
                l3 = this.rescalingScheme == PartialsRescalingScheme.NONE ? BeagleBenchmarkFlag.SCALING_NONE.getMask() : (this.rescalingScheme == PartialsRescalingScheme.ALWAYS ? BeagleBenchmarkFlag.SCALING_ALWAYS.getMask() : BeagleBenchmarkFlag.SCALING_DYNAMIC.getMask());
                logger.info("\t\tRunning benchmarks to automatically select fastest BEAGLE resource for analysis or partition... ");
                object2 = BeagleFactory.getBenchmarkedResourceDetails(this.tipCount, n3, this.stateCount, this.patternCount, this.categoryCount, nArray, l, l2, 1, 1, 0, l3);
                logger.info(" Benchmark results, from fastest to slowest:");
                object = object2.iterator();
                while (object.hasNext()) {
                    String[] stringArray = object.next();
                    logger.info(stringArray.toString());
                }
                nArray = new int[]{((BenchmarkedResourceDetails)object2.get(0)).getResourceNumber()};
            }
            this.beagle = BeagleFactory.loadBeagleInstance(this.tipCount, n, n3, this.stateCount, this.patternCount, this.evolutionaryProcessDelegate.getEigenBufferCount(), n6, this.categoryCount, n5, nArray, l, l2);
            InstanceDetails instanceDetails = this.beagle.getDetails();
            ResourceDetails resourceDetails = null;
            if (instanceDetails != null) {
                resourceDetails = BeagleFactory.getResourceDetails(instanceDetails.getResourceNumber());
                if (resourceDetails != null) {
                    object2 = new StringBuilder("  Using BEAGLE resource ");
                    ((StringBuilder)object2).append(resourceDetails.getNumber()).append(": ");
                    ((StringBuilder)object2).append(resourceDetails.getName()).append("\n");
                    if (resourceDetails.getDescription() != null) {
                        for (String string6 : object = resourceDetails.getDescription().split("\\|")) {
                            if (string6.trim().length() <= 0) continue;
                            ((StringBuilder)object2).append("    ").append(string6.trim()).append("\n");
                        }
                    }
                    ((StringBuilder)object2).append("    with instance flags: ").append(instanceDetails.toString());
                    logger.info(((StringBuilder)object2).toString());
                } else {
                    logger.info("  Error retrieving BEAGLE resource for instance: " + instanceDetails.toString());
                }
            } else {
                logger.info("  No external BEAGLE resources available, or resource list/requirements not met, using Java implementation");
            }
            this.instanceFlags = instanceDetails.getFlags();
            if ((this.instanceFlags & BeagleFlag.THREADING_CPP.getMask()) != 0L) {
                if (BeagleFunctionality.IS_THREAD_COUNT_COMPATIBLE() && this.threadCount != 0) {
                    if (this.threadCount > 0) {
                        this.beagle.setCPUThreadCount(this.threadCount);
                        logger.info("    Using " + this.threadCount + " thread" + (this.threadCount > 1 ? "s" : "") + " for CPU.");
                    } else {
                        logger.info("    Using default thread count for CPU.");
                        this.beagle.setCPUThreadCount(1000);
                    }
                } else {
                    logger.info("    BEAGLE threading turned off (or unavailable) for CPU.");
                }
            }
            if (patternList instanceof UncertainSiteList) {
                bl = true;
            }
            logger.info("    " + (preOrderSettings.usePreOrder ? "Using" : "Ignoring") + " preOrder partials in tree likelihood.");
            logger.info("    " + (bl ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
            logger.info("    With " + patternList.getPatternCount() + " unique site patterns.");
            if (patternList.areUncertain() && !bl) {
                logger.info("    WARNING: Uncertain site patterns will be ignored.");
            }
            for (int i = 0; i < this.tipCount; ++i) {
                object = tree.getTaxonId(i);
                int n7 = patternList.getTaxonIndex((String)object);
                if (n7 == -1) {
                    throw new TaxonList.MissingTaxonException("Taxon, " + (String)object + ", in tree, " + tree.getId() + ", is not found in patternList, " + patternList.getId());
                }
                if (bl) {
                    this.setPartials(this.beagle, patternList, n7, i);
                    continue;
                }
                this.setStates(this.beagle, patternList, n7, i);
            }
            this.beagle.setPatternWeights(this.patternWeights);
            String string7 = "    Using rescaling scheme : " + this.rescalingScheme.getText();
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO && resourceDetails != null && (resourceDetails.getFlags() & BeagleFlag.SCALING_AUTO.getMask()) == 0L) {
                this.rescalingScheme = PartialsRescalingScheme.DYNAMIC;
                string7 = "    Auto rescaling not supported in BEAGLE, using : " + this.rescalingScheme.getText();
            }
            boolean bl5 = false;
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                string7 = string7 + " (rescaling every " + this.rescalingFrequency + " evaluations";
                bl5 = true;
            }
            if (this.delayRescalingUntilUnderflow) {
                string7 = string7 + (bl5 ? ", " : "(") + "delay rescaling until first overflow";
                bl5 = true;
            }
            string7 = string7 + (bl5 ? ")" : "");
            logger.info(string7);
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                this.everUnderflowed = false;
            }
            this.updateSubstitutionModel = true;
            this.updateSiteModel = true;
            this.updateRootFrequency = true;
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
        ++instanceCount;
    }

    public BeagleDataLikelihoodDelegate(Tree tree, PatternList patternList, BranchModel branchModel, SiteRateModel siteRateModel, boolean bl, boolean bl2, PartialsRescalingScheme partialsRescalingScheme, boolean bl3, PreOrderSettings preOrderSettings) {
        this(tree, patternList, branchModel, siteRateModel, bl, bl2, partialsRescalingScheme, bl3, preOrderSettings, null, null);
    }

    @Override
    public String getReport() {
        return null;
    }

    @Override
    public TreeTraversal.TraversalType getOptimalTraversalType() {
        if ((this.instanceFlags & BeagleFlag.FRAMEWORK_CPU.getMask()) != 0L) {
            return TreeTraversal.TraversalType.POST_ORDER;
        }
        return TreeTraversal.TraversalType.REVERSE_LEVEL_ORDER;
    }

    @Override
    public int getTraitCount() {
        return 1;
    }

    @Override
    public int getTraitDim() {
        return this.patternCount;
    }

    @Override
    public RateRescalingScheme getRateRescalingScheme() {
        return RateRescalingScheme.NONE;
    }

    public final BranchModel getBranchModel() {
        return this.branchModel;
    }

    public PatternList getPatternList() {
        return this.patternList;
    }

    public Beagle getBeagleInstance() {
        return this.beagle;
    }

    private int getSingleScaleBufferCount() {
        return this.internalNodeCount + 1;
    }

    private final void setPartials(Beagle beagle, PatternList patternList, int n, int n2) {
        int n3;
        double[] dArray = new double[this.patternCount * this.stateCount * this.categoryCount];
        int n4 = 0;
        for (n3 = 0; n3 < this.patternCount; ++n3) {
            if (patternList instanceof UncertainSiteList) {
                ((UncertainSiteList)patternList).fillPartials(n, n3, dArray, n4);
                n4 += this.stateCount;
                continue;
            }
            if (patternList.areUncertain()) {
                double[] dArray2 = patternList.getUncertainPatternState(n, n3);
                System.arraycopy(dArray2, 0, dArray, n4, this.stateCount);
                n4 += this.stateCount;
                continue;
            }
            int n5 = patternList.getPatternState(n, n3);
            boolean[] blArray = this.dataType.getStateSet(n5);
            for (int i = 0; i < this.stateCount; ++i) {
                dArray[n4] = blArray[i] ? 1.0 : 0.0;
                ++n4;
            }
        }
        int n6 = n3 = this.patternCount * this.stateCount;
        for (int i = 1; i < this.categoryCount; ++i) {
            System.arraycopy(dArray, 0, dArray, n6, n3);
            n6 += n3;
        }
        beagle.setPartials(n2, dArray);
    }

    private final void setPartials(Beagle beagle, TipStatesModel tipStatesModel, int n) {
        int n2;
        double[] dArray = new double[this.patternCount * this.stateCount * this.categoryCount];
        tipStatesModel.getTipPartials(n, dArray);
        int n3 = n2 = this.patternCount * this.stateCount;
        for (int i = 1; i < this.categoryCount; ++i) {
            System.arraycopy(dArray, 0, dArray, n3, n2);
            n3 += n2;
        }
        beagle.setPartials(n, dArray);
    }

    private final void setStates(Beagle beagle, PatternList patternList, int n, int n2) {
        int[] nArray = new int[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            nArray[i] = patternList.getPatternState(n, i);
        }
        beagle.setTipStates(n2, nArray);
    }

    @Override
    public double calculateLikelihood(List<ProcessOnTreeDelegate.BranchOperation> list, List<ProcessOnTreeDelegate.NodeOperation> list2, int n) throws DataLikelihoodDelegate.LikelihoodException {
        Iterator<ProcessOnTreeDelegate.NodeOperation> iterator;
        if (this.siteAssignInd != null) {
            this.setAllPatternWeights(this.siteAssignInd);
            this.beagle.setPatternWeights(this.patternWeights);
        }
        if (!this.delayRescalingUntilUnderflow || this.everUnderflowed) {
            if (this.rescalingScheme == PartialsRescalingScheme.ALWAYS || this.rescalingScheme == PartialsRescalingScheme.DELAYED) {
                this.useScaleFactors = true;
                this.recomputeScaleFactors = true;
            } else if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                this.useScaleFactors = true;
                if (this.rescalingCount > this.rescalingFrequency) {
                    this.rescalingCount = 0;
                    this.rescalingCountInner = 0;
                }
                if (this.rescalingCountInner < 1) {
                    this.recomputeScaleFactors = true;
                    ++this.rescalingCountInner;
                    throw new DataLikelihoodDelegate.LikelihoodRescalingException();
                }
                if (this.initialEvaluation) {
                    if (this.underflowHandling < 1) {
                        ++this.underflowHandling;
                    } else if (this.underflowHandling == 1) {
                        this.recomputeScaleFactors = true;
                        ++this.underflowHandling;
                        this.initialEvaluation = false;
                    }
                }
                ++this.rescalingCount;
            }
        }
        int n2 = 0;
        for (ProcessOnTreeDelegate.BranchOperation object : list) {
            this.branchUpdateIndices[n2] = object.getBranchNumber();
            this.branchLengths[n2] = object.getBranchLength();
            ++n2;
        }
        if (this.updateSubstitutionModel) {
            this.evolutionaryProcessDelegate.updateSubstitutionModels(this.beagle, this.flip);
        }
        if (this.updateSiteModel) {
            iterator = (Iterator<ProcessOnTreeDelegate.NodeOperation>)this.siteRateModel.getCategoryRates();
            if (iterator == null) {
                return Double.NEGATIVE_INFINITY;
            }
            this.beagle.setCategoryRates((double[])iterator);
            double[] n4 = this.siteRateModel.getCategoryProportions();
            this.beagle.setCategoryWeights(0, n4);
        }
        if (this.updateRootFrequency) {
            iterator = (Iterator<ProcessOnTreeDelegate.NodeOperation>)this.evolutionaryProcessDelegate.getRootStateFrequencies();
            this.beagle.setStateFrequencies(0, (double[])iterator);
        }
        if (n2 > 0) {
            this.evolutionaryProcessDelegate.updateTransitionMatrices(this.beagle, this.branchUpdateIndices, this.branchLengths, n2, this.flip);
        }
        this.totalMatrixUpdateCount += (long)n2;
        if (this.flip) {
            for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list2) {
                this.partialBufferHelper.flipOffset(nodeOperation.getNodeNumber());
            }
        }
        int n3 = list2.size();
        boolean bl = false;
        for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list2) {
            int n4 = nodeOperation.getNodeNumber();
            this.operations[var6_13] = this.partialBufferHelper.getOffsetIndex(n4);
            if (!(this.isRestored || this.partialBufferHelper.isSafeUpdate(n4) || this.recomputeScaleFactors)) {
                System.err.println("Stored partial should not be updated!");
            }
            if (this.useScaleFactors) {
                int n5 = n4 - this.tipCount;
                if (this.recomputeScaleFactors) {
                    this.scaleBufferHelper.flipOffset(n5);
                    this.scaleBufferIndices[n5] = this.scaleBufferHelper.getOffsetIndex(n5);
                    this.operations[var6_13 + true] = this.scaleBufferIndices[n5];
                    this.operations[var6_13 + 2] = -1;
                } else {
                    this.operations[var6_13 + true] = -1;
                    this.operations[var6_13 + 2] = this.scaleBufferIndices[n5];
                }
            } else {
                if (this.useAutoScaling) {
                    this.scaleBufferIndices[n4 - this.tipCount] = this.partialBufferHelper.getOffsetIndex(n4);
                }
                this.operations[var6_13 + true] = -1;
                this.operations[var6_13 + 2] = -1;
            }
            this.operations[var6_13 + 3] = this.partialBufferHelper.getOffsetIndex(nodeOperation.getLeftChild());
            this.operations[var6_13 + 4] = this.evolutionaryProcessDelegate.getMatrixIndex(nodeOperation.getLeftChild());
            this.operations[var6_13 + 5] = this.partialBufferHelper.getOffsetIndex(nodeOperation.getRightChild());
            this.operations[var6_13 + 6] = this.evolutionaryProcessDelegate.getMatrixIndex(nodeOperation.getRightChild());
            var6_13 += 7;
        }
        this.beagle.updatePartials(this.operations, n3, -1);
        ++this.totalEvaluationCount;
        this.totalPartialsUpdateCount += (long)n3;
        int n6 = this.partialBufferHelper.getOffsetIndex(n);
        int n7 = -1;
        if (this.useScaleFactors) {
            if (this.recomputeScaleFactors) {
                this.scaleBufferHelper.flipOffset(this.internalNodeCount);
                n7 = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
                this.beagle.resetScaleFactors(n7);
                this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, n7);
            } else {
                n7 = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
            }
        } else if (this.useAutoScaling) {
            this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, -1);
        }
        double[] dArray = new double[1];
        this.beagle.calculateRootLogLikelihoods(new int[]{n6}, new int[]{0}, new int[]{0}, new int[]{n7}, 1, dArray);
        double d = dArray[0];
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.everUnderflowed = true;
            d = Double.NEGATIVE_INFINITY;
            if (this.firstRescaleAttempt && (this.delayRescalingUntilUnderflow || this.rescalingScheme == PartialsRescalingScheme.DELAYED)) {
                if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC || this.rescalingCount == 0) {
                    if (this.rescalingMessageCount % 1000 == 0) {
                        if (this.rescalingMessageCount > 0) {
                            Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood (" + this.rescalingMessageCount + " messages not shown; " + this.getId() + ").");
                        } else if (this.getId() != null) {
                            Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood. Attempting a rescaling... (" + this.getId() + ")");
                        } else {
                            Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood. Attempting a rescaling...");
                        }
                    }
                    ++this.rescalingMessageCount;
                }
                this.useScaleFactors = true;
                this.recomputeScaleFactors = true;
                this.firstRescaleAttempt = false;
                --this.rescalingCount;
            }
            this.flip = false;
            this.underflowHandling = 0;
            if (USE_CACHED_EXCEPTION) {
                if (this.cachedException == null) {
                    this.cachedException = new DataLikelihoodDelegate.LikelihoodUnderflowException();
                }
                throw this.cachedException;
            }
            throw new DataLikelihoodDelegate.LikelihoodUnderflowException();
        }
        this.firstRescaleAttempt = true;
        this.recomputeScaleFactors = false;
        this.flip = true;
        this.updateSubstitutionModel = false;
        this.updateSiteModel = false;
        this.updateRootFrequency = false;
        return d;
    }

    @Override
    public double[] getSiteLogLikelihoods() {
        double[] dArray = new double[this.patternCount];
        this.beagle.getSiteLogLikelihoods(dArray);
        return dArray;
    }

    public void getPartials(int n, double[] dArray) {
        int n2 = -1;
        this.beagle.getPartials(this.partialBufferHelper.getOffsetIndex(n), n2, dArray);
    }

    private void setPartials(int n, double[] dArray) {
        this.beagle.setPartials(this.partialBufferHelper.getOffsetIndex(n), dArray);
    }

    private void setAllPatternWeights(Parameter parameter) {
        Arrays.fill(this.patternWeights, 0.0);
        for (int i = 0; i < parameter.getSize(); ++i) {
            int n = (int)parameter.getParameterValue(i);
            if ((int)this.partitionCat.getParameterValue(0) != n) continue;
            int n2 = this.patternList.getPatternIndex(i);
            this.patternWeights[n2] = this.patternWeights[n2] + 1.0;
        }
    }

    @Override
    public int getPartitionCat() {
        return (int)this.partitionCat.getParameterValue(0);
    }

    @Override
    public void makeDirty() {
        this.updateSiteModel = true;
        this.updateSubstitutionModel = true;
        this.updateRootFrequency = true;
        this.fireModelChanged();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.siteRateModel) {
            this.updateSiteModel = true;
        } else if (model == this.branchModel) {
            this.updateSubstitutionModel = true;
            this.updateRootFrequency = true;
        }
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.siteAssignInd) {
            this.setAllPatternWeights(this.siteAssignInd);
            this.beagle.setPatternWeights(this.patternWeights);
        }
    }

    @Override
    public void storeState() {
        if (this.siteAssignInd != null) {
            System.arraycopy(this.patternWeights, 0, this.storedPatternWeights, 0, this.patternWeights.length);
        }
        this.partialBufferHelper.storeState();
        this.evolutionaryProcessDelegate.storeState();
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.storeState();
            System.arraycopy(this.scaleBufferIndices, 0, this.storedScaleBufferIndices, 0, this.scaleBufferIndices.length);
        }
        this.flip = true;
        this.isRestored = false;
    }

    @Override
    public void restoreState() {
        Object[] objectArray;
        if (this.siteAssignInd != null) {
            this.updateSubstitutionModel = true;
            objectArray = this.patternWeights;
            this.patternWeights = this.storedPatternWeights;
            this.storedPatternWeights = objectArray;
        }
        this.updateSiteModel = true;
        this.updateRootFrequency = true;
        this.partialBufferHelper.restoreState();
        this.evolutionaryProcessDelegate.restoreState();
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.restoreState();
            objectArray = this.storedScaleBufferIndices;
            this.storedScaleBufferIndices = this.scaleBufferIndices;
            this.scaleBufferIndices = (int[])objectArray;
        }
        this.isRestored = true;
    }

    @Override
    public void setCallback(TreeDataLikelihood treeDataLikelihood) {
    }

    @Override
    public void setComputePostOrderStatisticsOnly(boolean bl) {
    }

    @Override
    public boolean providesPostOrderStatisticsOnly() {
        return false;
    }

    @Override
    public int vectorizeNodeOperations(List<ProcessOnTreeDelegate.NodeOperation> list, int[] nArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void acceptState() {
    }

    public final boolean isUsePreOrder() {
        return this.settings.usePreOrder;
    }

    public final EvolutionaryProcessDelegate getEvolutionaryProcessDelegate() {
        return this.evolutionaryProcessDelegate;
    }

    public final SiteRateModel getSiteRateModel() {
        return this.siteRateModel;
    }

    public final int getPartialBufferIndex(int n) {
        return this.partialBufferHelper.getOffsetIndex(n);
    }

    public final int getScaleBufferCount() {
        return this.scaleBufferHelper.getBufferCount();
    }

    public final int getPartialBufferCount() {
        return this.partialBufferHelper.getBufferCount();
    }

    @Override
    public PreOrderSettings getPreOrderSettings() {
        return this.settings;
    }

    @Override
    public boolean getPreferGPU() {
        return this.prefersGPU;
    }

    @Override
    public boolean getUseAmbiguities() {
        return this.useAmbiguities;
    }

    @Override
    public PartialsRescalingScheme getRescalingScheme() {
        return this.rescalingScheme;
    }

    @Override
    public boolean getDelayRescalingUntilUnderflow() {
        return this.delayRescalingUntilUnderflow;
    }

    @Override
    public long getTotalCalculationCount() {
        return this.totalPartialsUpdateCount;
    }

    private void releaseBeagle() throws Throwable {
        if (this.beagle != null && this.releaseSingleton) {
            this.beagle.finalize();
            this.releaseSingleton = false;
        }
    }

    public static void releaseBeagleDataLikelihoodDelegate(TreeDataLikelihood treeDataLikelihood) throws Throwable {
        DataLikelihoodDelegate dataLikelihoodDelegate = treeDataLikelihood.getDataLikelihoodDelegate();
        if (dataLikelihoodDelegate instanceof BeagleDataLikelihoodDelegate) {
            BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate = (BeagleDataLikelihoodDelegate)dataLikelihoodDelegate;
            beagleDataLikelihoodDelegate.releaseBeagle();
        }
    }

    public static void releaseAllBeagleInstances() throws Throwable {
        for (Likelihood likelihood : Likelihood.FULL_LIKELIHOOD_SET) {
            if (likelihood instanceof TreeDataLikelihood) {
                BeagleDataLikelihoodDelegate.releaseBeagleDataLikelihoodDelegate((TreeDataLikelihood)likelihood);
                continue;
            }
            if (!(likelihood instanceof CompoundLikelihood)) continue;
            for (Likelihood likelihood2 : ((CompoundLikelihood)likelihood).getLikelihoods()) {
                if (!(likelihood2 instanceof TreeDataLikelihood)) continue;
                BeagleDataLikelihoodDelegate.releaseBeagleDataLikelihoodDelegate((TreeDataLikelihood)likelihood2);
            }
        }
    }
}

