% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableDrugIngredients.R
\name{associatedDrugIngredients}
\alias{associatedDrugIngredients}
\title{Get the names of drug ingredients associated with codelist}
\usage{
associatedDrugIngredients(x, cdm, standardConcept = "Standard")
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}
}
\value{
A vector containing the concept names for all ingredient level codes
found in the concept table of cdm.
}
\description{
Get the names of drug ingredients associated with codelist
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all drug ingredients associated with a codelist
codelist <- newCodelist(list("codes1" = c(37498042L),
                             "codes2" = c( 42899580L, 35741956L)))
associatedDrugIngredients(x = codelist, cdm = cdm,
                         standardConcept = c("Standard", "Non-standard"))
}
}
