% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token.R
\name{cds_check_authentication}
\alias{cds_check_authentication}
\alias{cds_token_works}
\title{Check if authentication works with a specific token}
\usage{
cds_check_authentication(token = cds_get_token(), ...)

cds_token_works(token = cds_get_token(), ...)
}
\arguments{
\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}

\item{...}{Ignored}
}
\value{
\code{cds_check_authentication()} will return
some account information when successful but throws an error if
it is not. In contrast \code{cds_token_works()} returns a \code{logical}
value and will not throw an error upon failure.
}
\description{
Checks if the specified API key can be used for authentication at
the Climate Data Service.
}
\examples{
if (interactive() && cds_token_works()) {
  cds_check_authentication()
}
}
