% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{cds_download_jobs}
\alias{cds_download_jobs}
\title{Download specific jobs}
\usage{
cds_download_jobs(job_id, destination, names, ..., token = cds_get_token())
}
\arguments{
\item{job_id}{If a specific job identifier is listed here, only the files resulting
from those jobs are downloaded. If left blank, all successful jobs are downloaded.}

\item{destination}{Destination path to store downloaded files.}

\item{names}{File names for the downloaded files. If missing, the cryptic hexadecimal
file name is taken from the job.}

\item{...}{Ignored}

\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}
}
\value{
A \code{data.frame} of all downloaded files. Contains a column \code{local} with the path
to the locally stored files.
}
\description{
After submitting one or more jobs with \code{cds_submit_job()}, you can download the resulting
files with \code{cds_download_jobs()}. See \code{vignette("download")} for more details.
}
\examples{
if (interactive() && cds_token_works()) {
  job <- cds_submit_job(
      dataset        = "reanalysis-era5-pressure-levels",
      variable       = "geopotential",
      product_type   = "reanalysis",
      area           = c(n = 55, w = -1, s = 50, e = 10),
      year           = "2024",
      month          = "03",
      day            = "01",
      pressure_level = "1000",
      data_format    = "netcdf"
    )
  cds_download_jobs(job$jobID, tempdir())
}
}
