% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste2.R
\name{paste2}
\alias{paste2}
\title{Normal `paste` function with additional `collapse_last` argument.}
\usage{
paste2(..., collapse = NULL, collapse_last = NULL, sep = " ", recycle0 = FALSE)
}
\arguments{
\item{...}{one or more \R objects, to be converted to character vectors.}

\item{collapse}{an optional character string to separate the results.  Not
    \code{\link[base]{NA_character_}}.  When \code{collapse} is a string,
    the result is always a string (\code{\link[base]{character}} of length 1).}

\item{collapse_last}{(string, optional) The string to use for the last
instance while collapsing. All other elements will be pasted using
the normal `collapse` argument. If `collapse` is not set, `collapse_last`
will be ignored.}

\item{sep}{a character string to separate the terms.  Not
    \code{\link[base]{NA_character_}}.}

\item{recycle0}{\code{\link[base]{logical}} indicating if zero-length
    character arguments should result in the zero-length
    \code{\link[base]{character}(0)}.  Note that when \code{collapse} is
    a string, \code{recycle0} does \emph{not} recycle to zero-length, but
    to \code{""}.}
}
\value{
String. See`?paste` for details.
}
\description{
The base `paste` function but with the add on to also supply a
  `collapse_last` value to change the `collapse` argument at the last
  position. To get from "cat", "mouse", "dog" to a string
  "cat, mouse and dog", one simply needs to call
  `paste(c("cat","mouse","dog"), collapse = ", ", collapse_last = " and ")`
}
\examples{
{
  paste2(c("cat", "mouse", "dog"),
         collapse = ", ",
         collapse_last = " and ")
  #> [1] "cat, mouse and dog"
}
}
\references{
\url{https://stackoverflow.com/a/38276239}
}
