% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-ClustDiffGenes.R
\name{ClustDiffGenes}
\alias{ClustDiffGenes}
\alias{ClustDiffGenes,DISCBIO-method}
\title{ClustDiffGenes}
\usage{
ClustDiffGenes(
  object,
  K,
  pValue = 0.05,
  fdr = 0.01,
  export = FALSE,
  quiet = FALSE,
  filename_up = "Up-DEG-cluster",
  filename_down = "Down-DEG-cluster",
  filename_binom = "binomial-DEGsTable",
  filename_sigdeg = "binomial-sigDEG"
)

\S4method{ClustDiffGenes}{DISCBIO}(
  object,
  K,
  pValue = 0.05,
  fdr = 0.01,
  export = FALSE,
  quiet = FALSE,
  filename_up = "Up-DEG-cluster",
  filename_down = "Down-DEG-cluster",
  filename_binom = "binomial-DEGsTable",
  filename_sigdeg = "binomial-sigDEG"
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{K}{A numeric value of the number of clusters.}

\item{pValue}{A numeric value of the p-value. Default is 0.05.}

\item{fdr}{A numeric value of the false discovery rate. Default is 0.01.}

\item{export}{A logical vector that allows writing the final gene list in
excel file. Default is TRUE.}

\item{quiet}{if `TRUE`, suppresses intermediate text output}

\item{filename_up}{Name of the exported "up" file (if `export=TRUE`)}

\item{filename_down}{Name of the exported "down" file (if `export=TRUE`)}

\item{filename_binom}{Name of the exported binomial file}

\item{filename_sigdeg}{Name of the exported sigDEG file}
}
\value{
A list containing two tables.
}
\description{
Creates a table of cluster differences
}
\examples{
sc <- DISCBIO(valuesG1msTest)
sc <- Clustexp(sc, cln = 3, quiet = TRUE)
cdiff <- ClustDiffGenes(sc, K = 3, fdr = .3, export = FALSE)
str(cdiff)
cdiff[[2]]
}
