% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSResult.R
\name{dsFetch}
\alias{dsFetch}
\title{Get the raw result}
\usage{
dsFetch(res)
}
\arguments{
\item{res}{An object inheriting from \code{\link{DSResult-class}}.}
}
\description{
Wait for the result to be available and fetch the result from a previous assignment or aggregation operation that may have been
run asynchronously, in which case it is a one-shot call. When the assignment or aggregation operation was not asynchronous,
the result is wrapped in the object and can be fetched multiple times.
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsAssignExpr(con, "C", as.symbol("c(1, 2, 3)"))
res <- dsAggregate(con, as.symbol("length(C)"))
length <- dsFetch(res)
dsDisconnect(con)
}
}
\seealso{
Other DSResult generics: 
\code{\link{DSResult-class}},
\code{\link{dsGetInfo}()},
\code{\link{dsIsCompleted}()}
}
\concept{DSResult generics}
