% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{filter.by.dependencies}
\alias{filter.by.dependencies}
\title{Filters columns (sequence positions) by dependency}
\usage{
filter.by.dependencies(mi.threshold, use.max = FALSE)
}
\arguments{
\item{mi.threshold}{the minimum average or maximum mutual information required}

\item{use.max}{if \code{TRUE}, the maximum and otherwise the average mutual
information will be considered}
}
\value{
function that, given a \link{DLData} object, returns \code{TRUE} 
  for every column that does exceed the specified average mutual information
}
\description{
Filters columns based on the average or maximum mutual information of a column
to all other columns. Mutual information is normalized to to interval
[0,1], where 0 corresponds to independence and 1 to perfect dependence.
}
\examples{
fun <- filter.by.dependencies(mi.threshold = 0.3)
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
