% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{lynch_ontario_families_df}
\alias{lynch_ontario_families_df}
\title{Ontario Lynch Syndrome families}
\format{
A data frame with 765 observations and 11 variables:
\describe{
  \item{famID}{Integer family identifier}
  \item{indID}{Integer individual identifier}
  \item{fatherID}{Integer father's identifier}
  \item{motherID}{Integer mother's identifier}
  \item{gender}{Integer gender code}
  \item{status}{Integer disease status}
  \item{time}{Integer time variable}
  \item{currentage}{Integer current age}
  \item{mgene}{Integer mutation gene status}
  \item{proband}{Integer proband indicator}
  \item{relation}{Integer relationship code}
}
}
\source{
Data taken from the \pkg{FamEvent} package version 3.2.
}
\usage{
data(lynch_ontario_families_df)
}
\description{
This dataset, lynch_ontario_families_df, is a data frame containing data from 32 Lynch Syndrome families
segregating mismatch repair mutations selected from the Ontario Familial Colorectal Cancer Registry.
The dataset includes 765 individuals (both probands and relatives) with 11 variables per observation.
}
\details{
The dataset name has been kept as 'lynch_ontario_families_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
