# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Function to obtain Z for COMPO with C++.
#' @param lambda numeric value for mu.
#' @param nu numeric value for sigma.
#' @param max_terms numeric value.
#' @param tol numeric value.
#' @keywords internal
#' @export
#' @return returns the z value.
z_cpp <- function(lambda, nu, max_terms = 1000L, tol = 1e-10) {
    .Call('_DiscreteDists_z_cpp', PACKAGE = 'DiscreteDists', lambda, nu, max_terms, tol)
}

#' Function to obtain Z vectorial for COMPO with C++.
#' @param mu numeric vector.
#' @param sigma numeric vector.
#' @keywords internal
#' @export
#' @return returns the z value.
z_vec_cpp <- function(mu, sigma) {
    .Call('_DiscreteDists_z_vec_cpp', PACKAGE = 'DiscreteDists', mu, sigma)
}

#' Function to obtain d1 in the score for COMPO with C++.
#' @param lambda numeric value for mu.
#' @param nu numeric value for sigma.
#' @param max_terms numeric value.
#' @param tol numeric value.
#' @keywords internal
#' @export
#' @return returns the z value.
d1_dldm_compo_cpp <- function(lambda, nu, max_terms = 1000L, tol = 1e-10) {
    .Call('_DiscreteDists_d1_dldm_compo_cpp', PACKAGE = 'DiscreteDists', lambda, nu, max_terms, tol)
}

#' Function to obtain d1 vectorial in the score for COMPO with C++.
#' @param mu numeric vector.
#' @param sigma numeric vector.
#' @keywords internal
#' @export
d1_vec_dldm_compo_cpp <- function(mu, sigma) {
    .Call('_DiscreteDists_d1_vec_dldm_compo_cpp', PACKAGE = 'DiscreteDists', mu, sigma)
}

#' Function to obtain d2 in the score for COMPO with C++.
#' @param lambda numeric value for mu.
#' @param nu numeric value for sigma.
#' @param max_terms numeric value.
#' @param tol numeric value.
#' @keywords internal
#' @export
#' @return returns the z value.
d2_dldd_compo_cpp <- function(lambda, nu, max_terms = 1000L, tol = 1e-10) {
    .Call('_DiscreteDists_d2_dldd_compo_cpp', PACKAGE = 'DiscreteDists', lambda, nu, max_terms, tol)
}

#' Function to obtain d2 vectorial in the score for COMPO with C++.
#' @param mu numeric vector.
#' @param sigma numeric vector.
#' @keywords internal
#' @export
d2_vec_dldd_compo_cpp <- function(mu, sigma) {
    .Call('_DiscreteDists_d2_vec_dldd_compo_cpp', PACKAGE = 'DiscreteDists', mu, sigma)
}

#' Function to obtain the dCOMPO for a single value x
#' @param x numeric value for x.
#' @param mu numeric value for nu.
#' @param sigma numeric value for sigma.
#' @param log logical value for log.
#' @keywords internal
#' @export
#' @return returns the pmf for a single value x.
dCOMPO_single <- function(x, mu = 1, sigma = 1, log = FALSE) {
    .Call('_DiscreteDists_dCOMPO_single', PACKAGE = 'DiscreteDists', x, mu, sigma, log)
}

#' Function to obtain the dHYPERPO for a vector x
#' @param x numeric value for x.
#' @param mu numeric value for mu.
#' @param sigma numeric value for sigma.
#' @param log logical value for log.
#' @keywords internal
#' @export
#' @return returns the pmf for a vector.
dCOMPO_vec <- function(x, mu, sigma, log) {
    .Call('_DiscreteDists_dCOMPO_vec', PACKAGE = 'DiscreteDists', x, mu, sigma, log)
}

dDMOLBE_single <- function(x, mu = 1, sigma = 1, log = FALSE) {
    .Call('_DiscreteDists_dDMOLBE_single', PACKAGE = 'DiscreteDists', x, mu, sigma, log)
}

dDMOLBE_vec <- function(x, mu, sigma, log) {
    .Call('_DiscreteDists_dDMOLBE_vec', PACKAGE = 'DiscreteDists', x, mu, sigma, log)
}

#' Function to obtain F11 with C++.
#' @param gamma numeric value for gamma.
#' @param lambda numeric value for lambda.
#' @param maxiter_series numeric value.
#' @param tol numeric value.
#' @keywords internal
#' @export
#' @return returns the F11 value.
f11_cpp <- function(gamma, lambda, maxiter_series = 10000L, tol = 1.0e-10) {
    .Call('_DiscreteDists_f11_cpp', PACKAGE = 'DiscreteDists', gamma, lambda, maxiter_series, tol)
}

#' Function to obtain the dHYPERPO for a single value x
#' @param x numeric value for x.
#' @param mu numeric value for nu.
#' @param sigma numeric value for sigma.
#' @param log logical value for log.
#' @keywords internal
#' @export
#' @return returns the pmf for a single value x.
dHYPERPO_single <- function(x, mu = 1, sigma = 1, log = FALSE) {
    .Call('_DiscreteDists_dHYPERPO_single', PACKAGE = 'DiscreteDists', x, mu, sigma, log)
}

#' Function to obtain the dHYPERPO for a vector x
#' @param x numeric value for x.
#' @param mu numeric value for mu.
#' @param sigma numeric value for sigma.
#' @param log logical value for log.
#' @keywords internal
#' @export
#' @return returns the pmf for a vector.
dHYPERPO_vec <- function(x, mu, sigma, log) {
    .Call('_DiscreteDists_dHYPERPO_vec', PACKAGE = 'DiscreteDists', x, mu, sigma, log)
}

d1_dldm_hyperpo_cpp <- function(mu, sigma, max_terms = 1000L, tol = 1e-10) {
    .Call('_DiscreteDists_d1_dldm_hyperpo_cpp', PACKAGE = 'DiscreteDists', mu, sigma, max_terms, tol)
}

dldm_hyperpo_cpp <- function(x, mu, sigma) {
    .Call('_DiscreteDists_dldm_hyperpo_cpp', PACKAGE = 'DiscreteDists', x, mu, sigma)
}

fun_exp_6_single_cpp <- function(x, media, gamma) {
    .Call('_DiscreteDists_fun_exp_6_single_cpp', PACKAGE = 'DiscreteDists', x, media, gamma)
}

fun_exp_6_vec_cpp <- function(x, media, gamma) {
    .Call('_DiscreteDists_fun_exp_6_vec_cpp', PACKAGE = 'DiscreteDists', x, media, gamma)
}

obtaining_lambda_single_cpp <- function(media, gamma, tol = 1e-10, max_iter = 1000L) {
    .Call('_DiscreteDists_obtaining_lambda_single_cpp', PACKAGE = 'DiscreteDists', media, gamma, tol, max_iter)
}

obtaining_lambda_vec_cpp <- function(media, gamma) {
    .Call('_DiscreteDists_obtaining_lambda_vec_cpp', PACKAGE = 'DiscreteDists', media, gamma)
}

