% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{mlp_dia}
\alias{mlp_dia}
\title{Train a Multi-Layer Perceptron (Neural Network) Model for Classification}
\usage{
mlp_dia(X, y, tune = FALSE, cv_folds = 5)
}
\arguments{
\item{X}{A data frame of features.}

\item{y}{A factor vector of class labels.}

\item{tune}{Logical, whether to perform hyperparameter tuning using \code{caret}'s
default grid (if \code{TRUE}) or a fixed value (if \code{FALSE}).}

\item{cv_folds}{An integer, the number of cross-validation folds for \code{caret}.}
}
\value{
A \code{caret::train} object representing the trained MLP model.
}
\description{
Trains a Multi-Layer Perceptron (MLP) neural network model
using \code{caret::train} for binary classification.
}
\examples{
\donttest{
set.seed(42)
n_obs <- 50
X_toy <- data.frame(
  FeatureA = rnorm(n_obs),
  FeatureB = runif(n_obs, 0, 100)
)
y_toy <- factor(sample(c("Control", "Case"), n_obs, replace = TRUE),
                levels = c("Control", "Case"))

# Train the model
mlp_model <- mlp_dia(X_toy, y_toy)
print(mlp_model)
}
}
