% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bard.R
\name{bard}
\alias{bard}
\alias{read_bard}
\alias{read_bard_header}
\alias{read_bard_signal}
\title{Read in ECG and EGM data from Bard (LabSystem Pro)}
\usage{
read_bard(file, n = Inf)

read_bard_header(file)

read_bard_signal(file, n = Inf)
}
\arguments{
\item{file}{The path to the file where the data is located. It must be a
\strong{*.txt} file. See details below about its format.}

\item{n}{Number of signal values to return (this will be the same for each
channel of data). Defaults to all values.}
}
\value{
An \code{egm} class object that is a list of EP signals the format of a
\code{data.table}, with an attached \strong{header} attribute that contains
additional recording data.
}
\description{
This function allows for reading in LS Pro data based on their
text export of signals. Signals can be exported directly from the LS Pro
system. The actual software is written by \emph{Bard}.

The \href{https://www.bostonscientific.com/en-EU/medical-specialties/electrophysiology/arrhythmias/cardiac-mapping-system/electrophysiology-recording-system.html}{LabSystem Pro}
was acquired by Boston Scientific from the original company
\href{https://news.bostonscientific.com/2013-06-28-Boston-Scientific-To-Acquire-C-R-Bard-Electrophysiology-Business}{Bard}.
They are a common electrophysiology signal processing device for
visualization and measurement of intracardiac signals.
}
\section{Data Export}{
The steps to data export are as follows.
\enumerate{
\item Start LabSystem PRO
\item Open a patient record
\item Display a waveform recording in a Review Window
\item Scroll to a point of interest in a waveform recording
\item Right click on the review window to the left of the region of interest
\item Select an Export option, either a default time range or the entire visible
page (which depends on the sweep speed).
}
}

\section{Data Format}{
\if{html}{\out{<div class="sourceCode">}}\preformatted{[Header] Recording info – contains (example):

[Header]<CR><LF>
	 File Type: 1<CR><LF>
	 Version: 1<CR><LF>
	 Channels exported: 22<CR><LF>
	 Samples per channel: 5000<CR><LF>
	 Start time:  6:55:24<CR><LF>
	 End time:  6:55:29<CR><LF>
	 Ch. Info. Pointer: 320<CR><LF>
	 Stamp Data: T<CR><LF>
	 Mux format: 0<CR><LF>
	 Mux Block Size: <CR><LF>
	 Data Format 1<CR><LF>
	 Sample Rate: 1000Hz<CR><LF>

[Header] Channel info (per channel example):

  Channel #: 1<CR><LF>
  Label: III<CR><LF>
	 Range: 5mv <CR><LF>
	 Low: 1Hz<CR><LF>
	 High: 100Hz<CR><LF>
	 Sample rate: 1000Hz<CR><LF>
	 Color: 0000FF<CR><LF>
	 Scale: -7<CR><LF>

[Data] As described below:

	-256,-1056,576,-256,320,-736,144,576,-592,176,608,240,176,-560,496,-
	144,0,0,-32,-48,-32,-80<CR><LF>

}\if{html}{\out{</div>}}

Channel Data is interleaved in the example above (sample indexed at 1):\tabular{lllll}{
   1 \tab 2 \tab 3 \tab ... \tab 22 \cr
   Ch1:1 \tab Ch2:1 \tab Ch3:1 \tab ... \tab Ch22:1 \cr
   Ch1:2 \tab Ch2:2 \tab Ch3:2 \tab ... \tab Ch22:2 \cr
   Ch1:3 \tab Ch2:3 \tab Ch3:3 \tab ... \tab Ch22:3 \cr
   ... \tab ... \tab ... \tab ... \tab ... \cr
   Ch1:5000 \tab Ch2:5000 \tab Ch3:5000 \tab ... \tab Ch22:5000 \cr
}
}

