% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods-data.R
\docType{data}
\name{ooiLikelihoods}
\alias{ooiLikelihoods}
\title{Example profile likelihoods for a synthetic outcome of interest}
\format{
An objects of class \code{list}; the list contains 12 lists,
where each list includes several dataframes with column \code{point} and \code{value}
for adaptive grid profile likelihoods.
}
\usage{
ooiLikelihoods
}
\description{
A list that contain profile likelihoods for a synthetic outcome of interest.
They are extracted from a real-world observational healthcare database, with the
likelihoods profiled using adaptive grids using the \code{Cyclops} package.
}
\examples{
data("ooiLikelihoods")
ooiLikEx <- ooiLikelihoods[["5"]][[1]]
\donttest{
plot(value ~ point, data = ooiLikEx)
}
}
\references{
Schuemie et al. (2022). Vaccine safety surveillance using routinely collected
healthcare data—an empirical evaluation of epidemiological designs. Frontiers in Pharmacology.
}
\keyword{datasets}
