% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotBiasDistribution}
\alias{plotBiasDistribution}
\title{Plot bias distributions}
\usage{
plotBiasDistribution(
  biasDist,
  limits = c(-2, 2),
  logScale = FALSE,
  numericId = TRUE,
  fileName = NULL
)
}
\arguments{
\item{biasDist}{A bias distribution object generated by the \code{\link[=fitBiasDistribution]{fitBiasDistribution()}} or \code{\link[=sequentialFitBiasDistribution]{sequentialFitBiasDistribution()}} function.}

\item{limits}{The lower and upper limits in log-RR to plot.}

\item{logScale}{Whether or not to show bias in log-RR; default FALSE (shown in RR).}

\item{numericId}{(For sequential or group case only) whether or not to treat \code{Id} as a numeric variable; default: TRUE.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See
the function \link[ggplot2:ggsave]{ggplot2::ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A \code{ggplot} object. Use the \link[ggplot2:ggsave]{ggplot2::ggsave} function to save to file.
}
\description{
Plot bias distributions
}
\details{
Plot empirical bias distributions learned from analyzing negative controls.
}
\examples{
# Fit a bias distribution for this example:
data("ncLikelihoods")
# NOT RUN
# singleBiasDist = fitBiasDistribution(ncLikelihoods[[5]], seed = 1)

# Plot it
# NOT RUN
# plotBiasDistribution(singleBiasDist)

}
\seealso{
\link{fitBiasDistribution}, \link{sequentialFitBiasDistribution}
}
