% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_fars.R
\name{compute_fars}
\alias{compute_fars}
\title{Compute Factor Augmented Quantile Regressions}
\usage{
compute_fars(dep_variable, factors, h = 1, edge = 0.05)
}
\arguments{
\item{dep_variable}{Numeric vector of length T representing the dependent variable (e.g., GDP growth, inflation).}

\item{factors}{Numeric matrix or data frame of dimension T x r, containing factor estimates.}

\item{h}{Integer (>= 1). Lag order used in the regression (default = 1)}

\item{edge}{Numeric value specifying the trimming amount applied to the outermost quantiles. Default is 0.05.}
}
\value{
An object of class \code{fars}, which is a list containing:
\describe{
\item{\code{models}}{List of five S3 \code{quantreg::rq} fitted objects named \code{tau_0.xx}.}
\item{\code{h}}{The forecast horizon used.}
\item{\code{levels}}{The vector of quantile levels effectively estimated
(\code{c(edge, 0.25, 0.50, 0.75, 1 - edge)}).}
.  \item{\code{periods}}{Integer. The number of fitted periods}
\item{\code{n_factors}}{Integer. The number of factors included in the regression.}
\item{\code{call}}{The matched function call.}
}
}
\description{
Performs quantile regressions of a dependent variable on factors estimates.
}
\examples{
set.seed(123)
T <- 100; r <- 3
Y <- rnorm(T)
F <- matrix(rnorm(T * r), T, r)      
fars_result <- compute_fars(dep_variable = Y, factors = F, h = 1, edge = 0.05)
}
