% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.R
\name{print.feature}
\alias{print.feature}
\title{Print method for "feature" class}
\usage{
\method{print}{feature}(x, dataset = FALSE, alphas = FALSE, labels = FALSE, round = FALSE, ...)
}
\arguments{
\item{x}{An object of class "feature"}

\item{dataset}{Set the regular covariates as columns in a dataset}

\item{alphas}{Print a "?" instead of actual alphas to prepare the output for alpha estimation}

\item{labels}{Should the covariates be named, or just referred to as their place in the data.frame.}

\item{round}{Should numbers be rounded when printing? Default is FALSE, otherwise it can be set to the number of decimal places.}

\item{...}{Not used.}
}
\value{
String representation of a feature
}
\description{
Print method for "feature" class
}
\examples{
result <- gmjmcmc(matrix(rnorm(600), 100), P = 2, gaussian.loglik, NULL, c("p0", "exp_dbl"))
print(result$populations[[1]][1])

}
