% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvjmcs.R
\name{mvjmcs}
\alias{mvjmcs}
\title{Joint modeling of multivariate longitudinal and competing risks data}
\usage{
mvjmcs(
  ydata,
  cdata,
  long.formula,
  random = NULL,
  surv.formula,
  maxiter = 10000,
  opt = "nlminb",
  tol = 0.005,
  print.para = TRUE,
  initial.para = NULL,
  cpu.cores = NULL
)
}
\arguments{
\item{ydata}{A longitudinal data frame in long format.}

\item{cdata}{A survival data frame with competing risks or single failure. Each subject has one data entry.}

\item{long.formula}{A list of formula objects specifying fixed effects for each longitudinal outcome.}

\item{random}{A formula or list of formulas describing random effects structures (e.g., \code{~ 1|ID}).}

\item{surv.formula}{A formula for the survival sub-model, including survival time and event indicator.}

\item{maxiter}{Maximum number of EM iterations. Default is 10000.}

\item{opt}{Optimization method for mixed model. Default is \code{"nlminb"}.}

\item{tol}{Convergence tolerance for EM algorithm. Default is 0.0001.}

\item{print.para}{Logical; if \code{TRUE}, prints parameter values at each iteration.}

\item{initial.para}{Optional list of initialized parameters. Default is \code{NULL}.}

\item{cpu.cores}{Number of CPU cores for parallel computation. Default is 1.}
}
\value{
Object of class \code{mvjmcs} with elements
\item{beta}{the vector of all biomarker-specific fixed effects for the linear mixed effects sub-models.} 
\item{betaList}{the list of biomarker-specific fixed effects for the linear mixed effects sub-model.} 
\item{gamma1}{the vector of fixed effects for type 1 failure for the survival model.}
\item{gamma2}{the vector of fixed effects for type 2 failure for the survival model. 
Valid only if \code{CompetingRisk = TRUE}.}
\item{alpha1}{the vector of association parameter(s) for type 1 failure.}
\item{alpha2}{the vector of association parameter(s) for type 2 failure. Valid only if \code{CompetingRisk = TRUE}.}
\item{H01}{the matrix that collects baseline hazards evaluated at each uncensored event time for type 1 failure. 
The first column denotes uncensored event times, the second column the number of events, and the third columns 
the hazards obtained by Breslow estimator.}
\item{H02}{the matrix that collects baseline hazards evaluated at each uncensored event time for type 2 failure. 
The data structure is the same as \code{H01}. Valid only if \code{CompetingRisk = TRUE}.}
\item{Sig}{the variance-covariance matrix of the random effects.}
\item{sigma}{the vector of the variance of the biomarker-specific measurement error for the linear mixed effects sub-models.}
\item{iter}{the total number of iterations until convergence.}
\item{convergence}{convergence identifier: 1 corresponds to successful convergence, 
whereas 0 to a problem (i.e., when 0, usually more iterations are required).}
\item{vcov}{the variance-covariance matrix of all the fixed effects for both models.}
\item{FisherInfo}{the Empirical Fisher information matrix.}
\item{Score}{a matrix of the score function for all subjects.}
\item{sebeta}{the standard error of \code{beta}.}
\item{segamma1}{the standard error of \code{gamma1}.}
\item{segamma2}{the standard error of \code{gamma2}. 
Valid only if \code{CompetingRisk = TRUE}.}
\item{sealpha1}{the standard error of \code{nu1}.}
\item{sealpha2}{the standard error of \code{nu2}. Valid only if \code{CompetingRisk = TRUE}.}
\item{seSig}{the vector of standard errors of covariance of random effects.}
\item{sesigma}{the standard error of variance of biomarker-specific measurement error for the linear mixed effects sub-models.}
\item{pos.mode}{the posterior mode of the conditional distribution of random effects.}
\item{pos.cov}{the posterior covariance of the conditional distribution of random effects.}
\item{CompetingRisk}{logical value; TRUE if a competing event are accounted for.}
\item{ydata}{the input longitudinal dataset for fitting a joint model.
It has been re-ordered in accordance with descending observation times in \code{cdata}.}
\item{cdata}{the input survival dataset for fitting a joint model.
It has been re-ordered in accordance with descending observation times.}
\item{PropEventType}{a frequency table of number of events.}
\item{LongitudinalSubmodel}{the component of the \code{long.formula}.}
\item{SurvivalSubmodel}{the component of the \code{surv.formula}.}
\item{random}{the component of the \code{random}.}
\item{call}{the matched call.}
\item{id}{the grouping vector for the longitudinal outcome.}
\item{opt}{the numerical optimizer for obtaining the initial guess of the parameters in the linear mixed effects sub-models.}
\item{runtime}{the total computation time.}
}
\description{
Joint modeling of multivariate longitudinal continuous data and competing risks
}
\details{
Function fits a joint model for multiple longitudinal outcomes and competing risks using a fast EM algorithm.
}
\examples{


  require(FastJM)
  require(survival)
  require(future)
  require(future.apply)
  
  data(mvcdata)
  data(mvydata)

  \donttest{
  # Fit joint model with two biomarkers
  fit <- mvjmcs(ydata = mvydata, cdata = mvcdata, 
                long.formula = list(Y1 ~ X11 + X12 + time, 
                                    Y2 ~ X11 + X12 + time),
                random = list(~ time | ID,
                              ~ 1 | ID),
                surv.formula = Surv(survtime, cmprsk) ~ X21 + X22, maxiter = 1000, opt = "optim", 
                tol = 1e-3, print.para = FALSE)
  fit
  
  # Extract the parameter estimates of longitudinal sub-model fixed effects
  fixef(fit, process = "Longitudinal")
  
  # Extract the parameter estimates of survival sub-model fixed effects
  fixef(fit, process = "Event")
  
  # Obtain the random effects estimates for first 6 subjects 
  head(ranef(fit))
  }
  
}
