% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmvJMdata.R
\name{simmvJMdata}
\alias{simmvJMdata}
\title{Joint modeling of multivariate longitudinal and competing risks data}
\usage{
simmvJMdata(
  seed = 100,
  N = 200,
  increment = 0.7,
  beta = list(beta1 = c(5, 1.5, 2, 1), beta2 = c(10, 1, 2, 1)),
  sigma = c(0.5, 0.5),
  gamma1 = c(1, 0.5),
  gamma2 = c(-0.5, 0.5),
  alpha1 = list(alpha11 = c(0.5, 0.7), alpha12 = c(-0.5, 0.5)),
  alpha2 = list(alpha21 = c(0.5, 0.7), alpha22 = c(-0.5, 0.5)),
  lambda1 = 0.05,
  lambda2 = 0.025,
  CL = 5,
  CU = 10,
  covb = diag(rep(1, 4)),
  missprob = 0,
  CR = TRUE
)
}
\arguments{
\item{seed}{a random seed number specified for simulating a joint model dataset.}

\item{N}{an integer to specify the sample size.}

\item{increment}{a scalar to specify the increment of visit time for longitudinal measurements.}

\item{beta}{a list of true parameters for the linear mixed effects sub-models. 
Each component of the list correspond to a specific biomarker.}

\item{sigma}{a vector of true error variance for all biomarkers.}

\item{gamma1}{a vector of true parameters of survival fixed effects for failure 1.}

\item{gamma2}{a vector of true parameters of survival fixed effects for failure 2.}

\item{alpha1}{a list of true parameters for the association parameters for failure 1. 
Each component of the list correspond to a specific biomarker.}

\item{alpha2}{a list of true parameters for the association parameters for failure 2. 
Each component of the list correspond to a specific biomarker.}

\item{lambda1}{the baseline hazard rate of failure 1. 
An exponential distribution with a rate parameter of \code{lambda1} is assumed.}

\item{lambda2}{the baseline hazard rate of failure 2. 
An exponential distribution with a rate parameter of \code{lambda2} is assumed.}

\item{CL}{a lower limit of a uniform distribution to be specified for the censoring time.}

\item{CU}{an upper limit of a uniform distribution to be specified for the censoring time.}

\item{covb}{a matrix of variance-covariance matrix of random effects.}

\item{missprob}{a scalar (ranging from 0 to 1) to specify the probability of 
missing longitudinal observations. Default is 0.}

\item{CR}{logical; if \code{TRUE}, simulate competing risks time-to-event data with 2 failures.
Default is \code{TRUE}.}
}
\value{
a list of datasets for both longitudinal and survival data with the elements
\item{mvydata}{a long-format data frame of longitudinal data.} 
\item{mvcdata}{a dataframe of survival data.}
}
\description{
Data simulation from the joint model of multivariate longitudinal biomarkers and time-to-event data
}
