% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCovariates.R
\name{getDbCovariateData}
\alias{getDbCovariateData}
\title{Get covariate information from the database}
\usage{
getDbCovariateData(
  connectionDetails = NULL,
  connection = NULL,
  oracleTempSchema = NULL,
  cdmDatabaseSchema,
  cdmVersion = "5",
  cohortTable = "cohort",
  cohortDatabaseSchema = cdmDatabaseSchema,
  cohortTableIsTemp = FALSE,
  cohortId = -1,
  cohortIds = c(-1),
  rowIdField = "subject_id",
  covariateSettings,
  aggregated = FALSE,
  minCharacterizationMean = 0,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{connectionDetails} created using the
function \code{createConnectionDetails} in the
\code{DatabaseConnector} package. Either the \code{connection} or
\code{connectionDetails} argument should be specified.}

\item{connection}{A connection to the server containing the schema as created using the
\code{connect} function in the \code{DatabaseConnector} package.
Either the \code{connection} or \code{connectionDetails} argument
should be specified.}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}

\item{cdmDatabaseSchema}{The name of the database schema that contains the OMOP CDM instance.
Requires read permissions to this database. On SQL Server, this should
specify both the database and the schema, so for example
'cdm_instance.dbo'.}

\item{cdmVersion}{Define the OMOP CDM version used: currently supported is "5".}

\item{cohortTable}{Name of the (temp) table holding the cohort for which we want to
construct covariates}

\item{cohortDatabaseSchema}{If the cohort table is not a temp table, specify the database schema
where the cohort table can be found. On SQL Server, this should
specify both the database and the schema, so for example
'cdm_instance.dbo'.}

\item{cohortTableIsTemp}{Is the cohort table a temp table?}

\item{cohortId}{DEPRECATED:For which cohort ID(s) should covariates be constructed? If set to -1,
covariates will be constructed for all cohorts in the specified cohort
table.}

\item{cohortIds}{For which cohort ID(s) should covariates be constructed? If set to c(-1),
covariates will be constructed for all cohorts in the specified cohort
table.}

\item{rowIdField}{The name of the field in the cohort table that is to be used as the
row_id field in the output table. This can be especially usefull if
there is more than one period per person.}

\item{covariateSettings}{Either an object of type \code{covariateSettings} as created using one
of the createCovariate functions, or a list of such objects.}

\item{aggregated}{Should aggregate statistics be computed instead of covariates per
cohort entry? If aggregated is set to FALSE, the results returned will be based
on each subject_id and cohort_start_date in your cohort table. If your cohort
contains multiple entries for the same subject_id (due to different cohort_start_date values),
you must carefully set the rowIdField so you can identify the patients properly.
See issue #229 for more discussion on this parameter.}

\item{minCharacterizationMean}{The minimum mean value for characterization output. Values below this will be cut off from output. This
will help reduce the file size of the characterization output, but will remove information
on covariates that have very low values. The default is 0.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}
}
\value{
Returns an object of type \code{covariateData}, containing information on the covariates.
}
\description{
Uses one or several covariate builder functions to construct covariates.
}
\details{
This function uses the data in the CDM to construct a large set of covariates for the provided
cohort. The cohort is assumed to be in an existing table with these fields: 'subject_id',
'cohort_definition_id', 'cohort_start_date'. Optionally, an extra field can be added containing the
unique identifier that will be used as rowID in the output.
}
\examples{
\donttest{
eunomiaConnectionDetails <- Eunomia::getEunomiaConnectionDetails()
covSettings <- createDefaultCovariateSettings()
Eunomia::createCohorts(
  connectionDetails = eunomiaConnectionDetails,
  cdmDatabaseSchema = "main",
  cohortDatabaseSchema = "main",
  cohortTable = "cohort"
)
covData <- getDbCovariateData(
  connectionDetails = eunomiaConnectionDetails,
  tempEmulationSchema = NULL,
  cdmDatabaseSchema = "main",
  cdmVersion = "5",
  cohortTable = "cohort",
  cohortDatabaseSchema = "main",
  cohortTableIsTemp = FALSE,
  cohortIds = -1,
  rowIdField = "subject_id",
  covariateSettings = covSettings,
  aggregated = FALSE
)
}

}
