% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_alphacuts_17102018.R
\name{is.trfuzzification}
\alias{is.trfuzzification}
\title{Verifies if a matrix is a fuzzification matrix of trapezoidal fuzzy numbers}
\usage{
is.trfuzzification(data)
}
\arguments{
\item{data}{a matrix of 4 columns (p,q,r,s), where p \eqn{\le} q \eqn{\le} r \eqn{\le} s. No NA are allowed.}
}
\value{
A value TRUE if the concerned object is a trapezoidal or triangular fuzzification matrix, FALSE otherwise.
}
\description{
Verifies if a matrix is a fuzzification matrix of trapezoidal fuzzy numbers
}
\examples{
mat <- matrix(c(1,1,2,2,3,3,4,4),ncol=4)
is.trfuzzification(mat)
}
