library(testthat)
# source("../../R/apply_measures.R")

local({
  x <- c(0.14268, 0.21757, -0.529, -0.36383, -0.77226, -0.40324, 0.89915, 0.78311, 0.78458, 0.19789, 0.43919, 0.32208, 0.64713, 0.78197, 0.63962)
  y <- c(0.26385, 0.27295, 0.29220, 0.79510, 0.17902, 0.22625, 0.54374, 0.35098, 0.18611, 0.19456, -0.85896, -0.81587, -0.58503, -0.40719, 0.11020)
  z <- c(0.27722, 0.20296, 0.35092, 0.27459, 0.45962, 0.41295, -0.86575, -0.66672, -0.11755, -0.52654, 0.86727, 0.56019, 0.35358, 0.74724, 0.69328)

  data <- data.frame(x, y, z)

  expected_AGSA <- c(
    0.59155743, 0.596228816, 0.301167626, 0.083508894, 0.083657153, 0.380065114, 0.361487045, 0.086721579,
    0.18512534, 0.404803883, 0.297249934, 0.040765209, 0.058694442, 0.155702555, 0.050318505
  )

  expected_ENMO <- c(
    0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.3614870446, 0.0867215793,
    0.00, 0.00, 0.2972499337, 0.0407652086, 0.00, 0.1557025546, 0.00
  )

  expected_updown <- c(
    40.23997672, 42.53198505, 24.7163318, 60.17493627, 11.26596249, 21.40497851, 23.53893403, 18.84271865,
    13.20235891, 19.07974679, -41.46322316, -51.62031077, -38.42642319, -20.62996458, 6.663551065
  )

  expected_degrees <- c(
    342.0, 2.0, 259.0, 262.0, 256.0, 271.0, 89.0, 85.0,
    53.0, 114.0, 341.0, 344.0, 16.0, 1.0, 357.0
  )


  expected_radians <- c(
    0.475323691, 0.820126069, 5.298102219, 5.358904441, 5.249243719, 5.509683322, 2.337272164, 2.276087903,
    1.719515497, 2.782093726, 0.468758595, 0.521795038, 1.070735313, 0.808105333, 0.745161807
  )



  test_that("AGSA calculation is correct", {
    expect_equal((apply_AGSA(data)$AGSA), expected_AGSA)
  })

  test_that("ENMO calculation is correct", {
    expect_equal((apply_ENMO(data)$ENMO), expected_ENMO)
  })

  test_that("UpDown calculation is correct", {
    expect_equal((apply_updown(data)$updown), expected_updown)
  })

  test_that("Degrees calculation is correct", {
    expect_equal((apply_degrees(data)$degrees), expected_degrees)
  })

  test_that("Radians calculation is correct", {
    expect_equal((apply_radians(data)$radians), expected_radians)
  })
})
