% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_score_calculator.R
\name{zscore}
\alias{zscore}
\title{Calculate Z-Scores from Count Tables}
\usage{
zscore(scored_table, control_table)
}
\arguments{
\item{scored_table}{Data frame of samples to be scored (genes as rows, samples as columns). All columns must be numeric.}

\item{control_table}{Data frame of control samples (genes as rows, samples as columns). All columns must be numeric.}
}
\value{
A data frame with the sum of Z-scores per sample and the sample IDs.
}
\description{
This function computes a Z-score sum for each sample in the given "scored" count table, based on
the means and SDs of the genes in the control table.
}
\examples{
# Example data to be scored
scored_table <- data.frame(
  sample1 = c(1, 2, 3),
  sample2 = c(4, 5, 6),
  sample3 = c(7, 8, 9)
)
rownames(scored_table) <- c("gene1", "gene2", "gene3")

# Example control data
control_table <- data.frame(
  control1 = c(1, 1, 1),
  control2 = c(2, 2, 2),
  control3 = c(3, 3, 3)
)
rownames(control_table) <- c("gene1", "gene2", "gene3")

# Calculate Z-score for each sample of the scored_table
zscore(scored_table, control_table)
}
