% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KmtFunc.R
\name{GetCV}
\alias{GetCV}
\title{Obtain Critical Value Table}
\usage{
GetCV(strDist, Modified)
}
\arguments{
\item{strDist}{the name of the null distribution for the hypothesis test: Normal, Cauchy, or Logistic. Other distributions such as Gumbel, Weibull and Frechet will be available in later versions.}

\item{Modified}{a logical value which specifies whether or not to use the modeifed version of the test: False calls the original version while True calls the modified version.}
}
\value{
A 10-by-6 table of critical values for various significance levles (0.1, 0.075, 0.05, 0.025, 0.01) and sample sizes (10,20,...,100).
}
\description{
Obtain critical values of the Khmaladze martingale transformation test for various significane levels and sample sizes
}
\examples{



### Critical values of the original test for a normal distribution


strDist = "Normal"
Modified=FALSE
CritValue = GetCV(strDist, Modified)



## Critical values of the modified test for the logistic distribution
strDist = "Logistic"
Modified=TRUE
CritValue = GetCV(strDist, Modified)



##Critical values of the modified test for the Cauchy distribution
strDist = "Cauchy"
Modified=TRUE
CritValue = GetCV(strDist, Modified)

}
\seealso{
KhmaladzeTrans()
}
