% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_graphs.R
\name{LBBNN_plot}
\alias{LBBNN_plot}
\title{Function to plot an input skip structure after removing weights in non-active paths.}
\usage{
LBBNN_plot(
  model,
  layer_spacing = 1,
  neuron_spacing = 1,
  vertex_size = 10,
  label_size = 0.5,
  edge_width = 0.5,
  save_svg = NULL
)
}
\arguments{
\item{model}{A trained \code{LBBNN_Net} model with input_skip enabled.}

\item{layer_spacing}{numeric, spacing in between layers.}

\item{neuron_spacing}{numeric, spacing between neurons within a layer.}

\item{vertex_size}{numeric, size of the neurons.}

\item{label_size}{numeric, size of the text within neurons.}

\item{edge_width}{numeric, width of the edges connecting neurons.}

\item{save_svg}{the path where the plot will be saved if save_svg is not null.}
}
\value{
This function produces plots as a side effect and does not return a value.
}
\description{
Uses igraph to plot.
}
\examples{
\donttest{
sizes <- c(2,3,3,2)
problem <- 'multiclass classification'
inclusion_priors <- c(0.1,0.1,0.1)
std_priors <- c(1.0,1.0,1.0)
inclusion_inits <- matrix(rep(c(-10,10),3), nrow = 2, ncol = 3)
device <- 'cpu'
torch::torch_manual_seed(0)
model <- LBBNN_Net(problem_type = problem, sizes = sizes,
                   prior = inclusion_priors, inclusion_inits = inclusion_inits,
                   input_skip = TRUE, std = std_priors, flow = FALSE,
                   num_transforms = 2, dims = c(200,200), device = device)
model$compute_paths_input_skip()
LBBNN_plot(model, 1, 1, 14, 1)
}
}
