% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prepare_Graph_Input.R
\name{attach_attributes}
\alias{attach_attributes}
\title{Attach attributes to a family graphs}
\usage{
attach_attributes(
  cur_fam_graph,
  cur_proband,
  fid,
  attr_tbl,
  attr_names,
  censor_proband_thrs = TRUE
)
}
\arguments{
\item{cur_fam_graph}{An igraph object (neighbourhood graph around a proband) with family members up to degree n.}

\item{cur_proband}{Current proband id (center of the neighbourhood graph).}

\item{fid}{Column name of family id.}

\item{attr_tbl}{Tibble with family id and attributes for each family member.}

\item{attr_names}{Names of attributes to be assigned to each node (family member) in the graph.}

\item{censor_proband_thrs}{Should proband's upper and lower thresholds be made uninformative? Defaults to TRUE. Used to exclude proband's information for prediction.}
}
\value{
igraph object (neighbourhood graph around a proband) with updated attributes for each node in the graph.
}
\description{
This function attaches attributes to family graphs, such as lower and upper thresholds, for each family member. This allows for a user-friendly way to attach personalised thresholds and other per-family specific attributes to the family graphs.
}
