#' Internal Logic Forest Functions
#'
#' INTERNAL FUNCTION TO CREATE COMBINATIONS OF N.PAIR VARIABLES
#' This function is called by \code{prime.imp}. It is not intended to be used independently of this function.
#' @param n.pair number of predictors in the tree 
#' @param conj value denoting absence of variable in combination 
#' 
#' @returns mat matrix with each combination of n.pair variables
#' @export
#' @keywords internal
#' 
p.combos<-function(n.pair,conj=0)
{
  mat<-matrix(0,2^n.pair,n.pair)
  for(i in 1:n.pair)
  {
    mat[, i]<-rep(rep(c(1,conj),e=2^(n.pair-i)),2^(i-1))
  }
  mat
}
