% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria_GLP.R
\name{criteria.GLP}
\alias{criteria.GLP}
\title{Calculates the values of the Generalised LP-criterion and its components}
\usage{
criteria.GLP(X1, X2, search.object, eps = 1e-23)
}
\arguments{
\item{X1}{The primary model matrix, with the first column containing the labels of treatments, and the second -- the intercept term.}

\item{X2}{The matrix of potential terms, with the first column containing the labels of treatments.}

\item{search.object}{Object of class \code{\link[=mood]{mood()}} specifying experiment parameters.}

\item{eps}{Computational tolerance, the default value is 10^-23}
}
\value{
A list of values: indicator of whether the evaluation was successful ("eval"), Ls-criterion value -- intercept excluded ("L"),
LP-criterion value -- intercept excluded ("LP"), Lack-of-fit(LP) criterion value ("LoF"), the bias component value ("bias"),
the number of pure error degrees of freedom ("df") and the value of the compound criterion ("compound").
}
\description{
This function evaluates the Generalised LP-criterion for given primary and potential model matrices.
Components: L-, LP-, LoF(LP)- and Bias(L)-optimality.
}
\examples{
#' # Experiment: one 5-level factor, primary model -- full quadratic, X^3 and X^4 potential terms.
ex.mood <- mood(K = 1, Levels = 5, Nruns = 8, criterion.choice = "GLP", 
               kappa = list(kappa.L = .25, kappa.LoF = .25, kappa.bias = .25, kappa.LP = .25), 
               model_terms = list(primary.model = "second_order", potential.terms = "x14"))
# Generating candidate sets: primary and full orthonormalised ones
K <- ex.mood$K
Levels <- ex.mood$Levels 
cand.not.orth <- candidate_set_full(candidate_trt_set(Levels, K), K)
cand.full.orth <- candidate_set_orth(cand.not.orth, ex.mood$primary.terms, ex.mood$potential.terms)
# Choosing a design
index <- c(rep(1,2),3,rep(4,2),rep(5,3))
X.primary <- cand.full.orth[index, c(1, match(ex.mood$primary.terms, colnames(cand.full.orth)))]
X.potential <- cand.full.orth[index, 
(c(1, match(ex.mood$potential.terms, colnames(cand.full.orth))))]
# Evaluating a compound GDP-criterion
criteria.GLP(X1 = X.primary, X2 = X.potential, ex.mood)
# Output: eval = 1, L = 0.2952603, LP = 4.584705, LoF = 3.895182, 
# bias = 1.03807, df = 4, compound = 1.529564

}
