% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RperT2.R
\name{RperT2}
\alias{RperT2}
\title{Robust Permutation Hotelling T^2 Test in High Dimensional Data}
\usage{
RperT2(X1, X2, alpha = 0.75, N = 100)
}
\arguments{
\item{X1}{the data matrix for the first group. It must be matrix or data.frame.}

\item{X2}{the data matrix for the first group. It must be matrix or data.frame.}

\item{alpha}{numeric parameter controlling the size of the subsets over which the determinant is minimized. 
Allowed values are between 0.5 and 1 and the default is 0.75.}

\item{N}{the permutation number}
}
\value{
a list with 2 elements:
\item{T2}{The calculated value of Robust Hotelling T^2 statistic based on MRCD estimations}
\item{p.value}{p value obtained from test process}
}
\description{
Robust Permutation Hotelling T^2 Test for Two Independent Samples in high Dimensional Data
}
\details{
\code{RperT2} function performs a robust permutation Hotelling T^2 test for two independent samples in high dimensional test based on the minimum regularized covariance determinant estimators.
}
\examples{

library(rrcov)
x<-mvtnorm::rmvnorm(n=10,sigma=diag(20),mean=rep(0,20))
y<-mvtnorm::rmvnorm(n=10,sigma=diag(20),mean=rep(1,20))
RperT2(X1=x,X2=y)$p.value
}
\references{
Bulut, H (2023). A robust Hotelling test statistic for two samples case in high dimensional data. (Unpublished)
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
