% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rozeboom.R
\name{Rozeboom}
\alias{Rozeboom}
\alias{sqveccor}
\title{Rozeboom's squared vector correlation}
\usage{
Rozeboom(X1, X2)

sqveccor(X1, X2)
}
\arguments{
\item{X1}{first \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{X2}{second \code{matrix} to be compared (\code{data.frames} are also accepted).}
}
\value{
A single value measuring the similarity of two matrices. For diagnostic purposes it is accompanied by an attribute "canonical.correlation".
}
\description{
Rozeboom's squared vector correlation
}
\examples{
X <- matrix(rnorm(100*13),nrow=100)
X1 <- X[, 1:5]  # Random normal
X2 <- X[, 6:12] # Random normal
X2[,1] <- X2[,1] + X[,5] # Overlap in one variable
Rozeboom(X1, X2)

}
\references{
Rozeboom, WW; 1965. "Linear correlations between sets of variables". Psychometrika 30(1): 57-71.
}
\seealso{
\code{\link{SMI}}, \code{\link{RV}} (RV2/RVadj), \code{\link{Coxhead}}, \code{\link{r1}} (r2/r3/r4/GCD).
}
\author{
Korbinian Strimmer and Kristian Hovde Liland
}
