% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{tbl_sum_taxtable}
\alias{tbl_sum_taxtable}
\title{Summarize a tax_table (taxonomic slot of phyloseq object) using gtsummary}
\usage{
tbl_sum_taxtable(physeq, taxonomic_ranks = NULL, ...)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{taxonomic_ranks}{A list of taxonomic ranks we want to summarized.}

\item{...}{Additional arguments passed on to \code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}}}
}
\value{
A table of class c('tbl_summary', 'gtsummary')
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Mainly a wrapper for the \code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}} function in the case
of \code{physeq} object.
}
\examples{
tbl_sum_taxtable(data_fungi_mini)
data_fungi_mini |>
  filt_taxa_pq(min_occurence = 2) |>
  tbl_sum_taxtable(taxonomic_rank = c("Species", "Genus"))
}
\author{
Adrien Taudière
}
