% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{boot.mcor.ic}
\alias{boot.mcor.ic}
\title{Intervalles de confiance bootstrap pour une matrice de corrélation de Bravais-Pearson}
\usage{
boot.mcor.ic(mat, boot.mcor.res, conflevel = 0.95)
}
\arguments{
\item{mat}{Matrice des données}

\item{boot.mcor.res}{Résultat du bootstrap de la matrice de corrélation de Bravais-Pearson}

\item{conflevel}{Niveau de confiance pour les intervalles}
}
\value{
Liste de quatre éléments : matrice des limites inférieures des intervalles de confiance bootstrap percentile, matrice des limites supérieures des intervalles de confiance bootstrap percentile, matrice des limites inférieures des intervalles de confiance bootstrap BCa, matrice des limites supérieures des intervalles de confiance bootstrap BCa
}
\description{
Intervalles de confiance bootstrap pour une matrice de corrélation de Bravais-Pearson
}
\examples{
data(Mesures5,package="BioStatR")
Mes5_red_lr = subset(Mesures5[,-5],subset=Mesures5$espece=="laurier rose")
library(boot)
boot.mcor <- boot(Mes5_red_lr[,c("masse","taille","masse_sec")], rho.mult, R=1000)
boot.mcor
boot.mcor.ic.res <- boot.mcor.ic(Mes5_red_lr[,c("masse", "taille","masse_sec")],boot.mcor)
boot.mcor.ic.res

}
