% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transf_value_to_na}
\alias{transf_value_to_na}
\title{Convert categorical missingness/non-response codes to \code{NA}}
\usage{
transf_value_to_na(
  data,
  missing_codes = c("999", "888", "777", "666", "555", "444", "333", "222"),
  ignore_col_pattern = "__dk$|__dk__l$",
  id_cols = union(get_id_cols_abcd(), get_id_cols_hbcd())
)
}
\arguments{
\item{data}{tibble. The labelled dataset and type converted data.}

\item{missing_codes}{character vector. The missing codes to be
converted to NA}

\item{ignore_col_pattern}{character. A regex pattern to ignore columns
that should not be converted to NA.}

\item{id_cols}{character vector. The names of the ID columns to be
excluded from the conversion (Default: identifier columns used in ABCD and
HBCD).}
}
\value{
A tibble of the dataset with missing codes converted to NA
}
\description{
This function converts the missing codes in the dataset to NA
in all factor columns. Example of missing codes are \code{999}, \code{888}, \code{777}, etc.
}
\details{
\subsection{Use case}{

This function works the best with \code{ABCD} data where the missing codes
are strictly defined. For \code{HBCD} data, the missing codes are still
under discussion. The function may work, but for some undecided future
missing codes, the function may not work as expected.

In case of \code{HBCD} data or other aribitrary missing codes that one wishes
to convert to NA, it is recommended to use the
\code{\link[sjmisc:set_na_if]{sjmisc::set_na_if()}} function instead.
}

\subsection{Input requirements}{

The data must be type transformed and labelled. See
\code{\link[=transf_factor]{transf_factor()}} and \code{\link[=transf_label]{transf_label()}} for details.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data <- data |>
  transf_factor() |>
  transf_label()
}\if{html}{\out{</div>}}
}
}
\examples{
\dontrun{
data <- data |>
  transf_factor() |>
  transf_label()

transf_value_to_na(data)
}
}
