% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\name{NNS.copula}
\alias{NNS.copula}
\title{NNS Co-Partial Moments Higher Dimension Dependence}
\usage{
NNS.copula(
  X,
  target = NULL,
  continuous = TRUE,
  plot = FALSE,
  independence.overlay = FALSE
)
}
\arguments{
\item{X}{a numeric matrix or data frame.}

\item{target}{numeric; Typically the mean of Variable X for classical statistics equivalences, but does not have to be. (Vectorized)  \code{(target = NULL)} (default) will set the target as the mean of every variable.}

\item{continuous}{logical; \code{TRUE} (default) Generates a continuous measure using degree 1 \link{PM.matrix}, while discrete \code{FALSE} uses degree 0 \link{PM.matrix}.}

\item{plot}{logical; \code{FALSE} (default) Generates a 3d scatter plot with regression points.}

\item{independence.overlay}{logical; \code{FALSE} (default) Creates and overlays independent \link{Co.LPM} and \link{Co.UPM} regions to visually reference the difference in dependence from the data.frame of variables being analyzed.  Under independence, the light green and red shaded areas would be occupied by green and red data points respectively.}
}
\value{
Returns a multivariate dependence value [0,1].
}
\description{
Determines higher dimension dependence coefficients based on co-partial moment matrices ratios.
}
\examples{
\dontrun{
set.seed(123)
x <- rnorm(1000) ; y <- rnorm(1000) ; z <- rnorm(1000)
A <- data.frame(x, y, z)
NNS.copula(A, target = colMeans(A), plot = TRUE, independence.overlay = TRUE)

### Target 0
NNS.copula(A, target = rep(0, ncol(A)), plot = TRUE, independence.overlay = TRUE)
}
}
\references{
Viole, F. (2016) "Beyond Correlation: Using the Elements of Variance for Conditional Means and Probabilities"  \doi{10.2139/ssrn.2745308}.
}
\author{
Fred Viole, OVVO Financial Systems
}
