% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotnetarray.R
\name{plotnetarray}
\alias{plotnetarray}
\title{Plot of network array data}
\usage{
plotnetarray(
  Y,
  n.graph = 4,
  node.size = 2,
  node.color = "brown",
  edge.alpha = 0.5,
  edge.size = 0.2,
  edge.color = "grey"
)
}
\arguments{
\item{Y}{network array data}

\item{n.graph}{number of subgraphs. Default is 4.}

\item{node.size}{node size.  Default is 2.}

\item{node.color}{node color.  Default is "brown."}

\item{edge.alpha}{transparency of edge.  Default is 0.5.}

\item{edge.size}{edge size.  Default is 0.2.}

\item{edge.color}{edge color.  Default is "grey."}
}
\value{
A plot object
}
\description{
Plot network array data
}
\examples{

   \dontrun{
   set.seed(1973)
   ## generate an array with two constant blocks
   Y <- MakeBlockNetworkChange(n=10, shape=1, T=20, type ="split")
   plotnetarray(Y)
   }
}
\references{
Jong Hee Park and Yunkyun Sohn. 2020. "Detecting Structural Change
in Longitudinal Network Data." \emph{Bayesian Analysis}. Vol.15, No.1, pp.133-157.
}
