% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableInObservation.R
\name{tableInObservation}
\alias{tableInObservation}
\title{Create a visual table from a summariseInObservation() result.}
\usage{
tableInObservation(result, type = "gt")
}
\arguments{
\item{result}{A summarised_result object.}

\item{type}{Type of formatting output table. See \code{visOmopResults::tableType()} for allowed options. Default is \code{"gt"}}
}
\value{
A formatted table object with the summarised data.
}
\description{
Create a visual table from a summariseInObservation() result.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch()

result <- summariseInObservation(
  observationPeriod = cdm$observation_period,
  interval = "months",
  output = c("person-days", "record"),
  ageGroup = list("<=60" = c(0, 60), ">60" = c(61, Inf)),
  sex = TRUE
)

result |>
  tableInObservation()

PatientProfiles::mockDisconnect(cdm)
}
}
