% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulations.R
\name{add_band}
\alias{add_band}
\title{Add Band}
\usage{
add_band(
  ftir_spectra_plot,
  wavenumber_range,
  text = NULL,
  colour = NULL,
  label_aesthetics = NULL
)
}
\arguments{
\item{ftir_spectra_plot}{A plot generated by \code{\link[=plot_ftir]{plot_ftir()}} or
\code{\link[=plot_ftir_stacked]{plot_ftir_stacked()}}.

Un tracé généré par \code{\link[=plot_ftir]{plot_ftir()}} ou \code{\link[=plot_ftir_stacked]{plot_ftir_stacked()}}.}

\item{wavenumber_range}{A vector of length two, with the wavenumber range of the shaded band.
Order of provided limits is not important.

Un vecteur de longueur deux, avec la gamme de nombres d'ondes de la bande ombrée.
L'ordre des limites fournies n'est pas important.}

\item{text}{The text of the label over the band (optional).

Le texte de l'étiquette au-dessus du bande (facultatif).}

\item{colour}{A colour for the shaded band. Note that alpha will be set to 0.5.
A default blue band will be added if not provided.
See \code{vignette("ggplot2-specs", "ggplot2")} for more information on aesthetics in graphics.

Une couleur pour la bande ombrée. Notez que la valeur alpha est fixée à 0,5.
Une bande bleue sera ajoutée par défaut si aucune valeur n'est fournie.
Voir \verb{vignette(« ggplot2-specs », « ggplot2 »)} pour plus d'informations sur l'esthétique dans les graphiques.}

\item{label_aesthetics}{A named \code{list} of aesthetics to pass to ggplot for
creating the label. See \verb{[ggplot2::geom_text()]}'s aesthetics section for
more info. Specifically, \code{alpha}, \verb{colo(u)r}, \code{family}, \code{fill}, \code{fontface} and
\code{size}are permitted. Positioning aesthetics will be removed.

Une \code{list} nommée d'esthétiques à transmettre à ggplot pour créer
l'étiquette. Voir la section esthétique de \verb{[ggplot2::geom_text()]} pour
plus d'informations. Plus précisément, \code{alpha}, \verb{colo(u)r}, \code{family}, \code{fill},
\code{fontface} et \code{size} sont autorisés. Les aspects esthétiques du
positionnement seront supprimés.}
}
\value{
the FTIR plot as a ggplot2 object, with the shaded band added.

le tracé FTIR en tant qu'objet ggplot2, avec la bande ombrée ajoutée.
}
\description{
Add a shaded band (with optional text overlay) to a FTIR spectral region, to visually highlight an area.

Ajoutez une bande ombrée (avec un texte en option) à une région spectrale FTIR, pour mettre visuellement en évidence une zone.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  # Generate a plot
  p <- plot_ftir(sample_spectra)

  # Add a band to -OH region:
  add_band(p, c(3600, 3100), "-OH Stretch")
}
}
\seealso{
\code{\link[=add_wavenumber_marker]{add_wavenumber_marker()}}
}
