% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtesting.R
\name{backtest_metrics}
\alias{backtest_metrics}
\title{Calculate Comprehensive Backtest Metrics}
\usage{
backtest_metrics(result)
}
\arguments{
\item{result}{Backtest result object from run_backtest()}
}
\value{
List containing performance metrics
}
\description{
Computes performance metrics including Sharpe ratio, maximum drawdown,
win rate, and other statistics from backtest results.
}
\examples{
# Create a backtest result to use
data(sample_prices_weekly)
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)
weights <- weight_equally(selected)
result <- run_backtest(sample_prices_weekly, weights)

# Calculate metrics
metrics <- backtest_metrics(result)
print(metrics$sharpe_ratio)
}
