% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical_indicators.R
\name{calc_rsi}
\alias{calc_rsi}
\title{Calculate Relative Strength Index (RSI)}
\usage{
calc_rsi(data, period = 14)
}
\arguments{
\item{data}{Data frame with Date column and price columns}

\item{period}{RSI period (default: 14)}
}
\value{
Data.table with RSI values (0-100 range)
}
\description{
Calculates RSI for each column. RSI ranges from 0-100.
Above 70 indicates overbought, below 30 indicates oversold.
}
\examples{
data("sample_prices_weekly")
rsi <- calc_rsi(sample_prices_weekly, period = 14)
overbought <- filter_above(rsi, 70)
}
