% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcReserve.R
\name{mcReserve}
\alias{mcReserve}
\title{MACRAME Based Development Profile Reserve}
\usage{
mcReserve(
  chainLadder,
  cum = TRUE,
  residuals = FALSE,
  states = NULL,
  breaks = NULL
)
}
\arguments{
\item{chainLadder}{a cumulative or incremental run-off triangle (the triangle
must be of the class \code{triangle} or \code{matrix}) in terms of a square
matrix with a fully observed upper-left triangular part. If the lower-right
part is also provided the function will also return standard residuals but
only the upper-left (run-off) triangle is be used for the reserve estimation
purposes}

\item{cum}{logical to indicate the time of the input triangle provided
(DEFAULT value is \code{TRUE} for the cumulative triangle, \code{FALSE} if
\code{chainLadder} is of the incremental type)}

\item{residuals}{logical to indicate whether (incremental) residuals should
be provided in output or not. If the run-off triangle is completely observed
then the residuals are obtained in terms of the true increments minus the
predicted ones. If the bottom-right triangle is not provided (\code{NA} values)
then the residuals are obtained in terms of a back-fitting approach
(see Maciak, Mizera, and Pešta (2022) for further details).
However, the back-fitted residuals are only calculated when
no user specification of the states (in \code{states}) and breaks
(in \code{breaks}) is provided}

\item{states}{numeric value to provide either the number of the Markov states
to be used or it can provide an explicit set of the states to be used.
The default setting (\code{states = NULL}) provides the set of states in a fully
data-driven manner as proposed in Maciak, Mizera, and Pešta (2022) while any
choice of  \code{breaks} is ignored. If the number of states is specified by
\code{states}, the states are obtained analogously as in Maciak, Mizera,
and Pešta (2022), however, the number of actual  states for the estimation is
adjusted and the parameter \code{breaks} is again ignored

If parameter \code{states} provides an explicit vector of Markov chain states
(the smallest state should be larger than the smallest observed increment in
the run-off triangle and, similarly, the largest state should be smaller than
the largest observed increment) then the corresponding bins (breaks) for the
run-off triangle increments are defined automatically by the midpoints between
the provided states (with \code{breaks} being set to \code{NULL} DEFAULT)}

\item{breaks}{vector parameter which provides explicit (unique and monotonly
increasing) break points (disjoint bins) for the run-off triangle incremenets.
Each bin should be represented by the corresponding Markov chain state---either
the values given in \code{states} or provided automatically if \code{states} is
not a valid vector of the Markov states. If the breaks are provided as
\code{breaks = c(-Inf, ... , Inf)} defining \code{k} bins all together then
\code{states} should be a vector of the same length \code{k}. Alternatively,
the breaks can be also specified by a set of finite numbers defining again
\code{k} bins---in such cases, the parameter \code{states} should be of the
length \code{length(states) = k + 1}. Each value in \code{states} should
represent one bin defined by \code{breaks}}
}
\value{
An object of the type \code{list} with with the following elements:
\item{reserve}{numeric vector with four values: Total paid amount (i.e., the
sum of the last observed diagonal in a cumulative run-off triangle); Total
estimated amount (i.e., the sum of the last column in the completed cumulative
triangle); Estimated reserve (i.e., the sum of the last column in the completed
cumulative triangle minus the sum of the last observed diagonal
in \code{chainLadder}); True reserve if a completed \code{chainLadder} is
provided in the output (i.e., the sum of the last column in \code{chainLadder}
minus the sum of the last diagonal in \code{chainLadder})}
\item{method}{algorithm used for the reserve estimation}
\item{fullTriangle}{completed run-off triangle (the upper-left triangular part
is identical with the input triangle in \code{chainLadder} and the lower-right
trianglular part is completed by the MACRAME algorithm}
\item{inputTriangle}{the input run-off triangle provided in \code{chainLadder}}
\item{trueCompleted}{true completed triangle (if available) where the upper-left
part is used by the MACRAME algorithm to estimate the reserve and the lower-right
part is provided for some evaluation purposes. If the full triangle is not
available \code{NA} is returned instead}
\item{residuals}{a triangle with the corresponding residuals (for
\code{residuals = TRUE}). The residuals are either provided in the upper-left
triangle (so-called back-fitted incremental residuals if true completed triangle
is not available) or the residuals are given in the lower-right triangle (i,e.,
standard incremental residuals---if the true completed triangle is given)}
}
\description{
The function takes a cumulative (or incremental) run-off triangle (partially
or completely observed) and returns the reserve estimate obtained by the
MACRAME algorithm (see Maciak, Mizera, and Pešta (2022) for further details).
}
\examples{
## run-off (upper-left) triangle with NA values
if (requireNamespace("ChainLadder")) {
data(MW2014, package = "ChainLadder")
print(MW2014) 

## MACRAME reserve prediction with the DEFAULT Markov chain setting 
mcReserve(MW2014, residuals = TRUE)}

## complete run-off triangle with 'unknown' truth (lower-bottom run-off triangle)  
## with incremental residuals (true increments minus predicted ones)  
data(CameronMutual)
mcReserve(CameronMutual, residuals = TRUE)

## the same output in terms of the reserve prediction but back-fitted residuals 
## are provided instead (as the run-off triangle only is provided)
data(observed(CameronMutual))
mcReserve(observed(CameronMutual), residuals = TRUE)

## MACRAME reserve prediction with the underlying Markov chain with five 
## explicit Markov chain states
mcReserve(CameronMutual, residuals = TRUE, states = c(200, 600, 1000))

}
\references{
Maciak, M., Mizera, I., and Pešta, M. (2022). Functional Profile
Techniques for Claims Reserving. ASTIN Bulletin, 52(2), 449-482. DOI:10.1017/asb.2022.4
}
\seealso{
\code{\link[=incrExplor]{incrExplor()}}, \code{\link[=permuteReserve]{permuteReserve()}}, \code{\link[=mcBreaks]{mcBreaks()}}, \code{\link[=mcStates]{mcStates()}}, \code{\link[=mcTrans]{mcTrans()}}
}
