% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-PET.R
\name{method.PET}
\alias{method.PET}
\title{PET (Precision-Effect Test) Method}
\usage{
\method{method}{PET}(method_name, data, settings = NULL)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (no settings version are implemented)}
}
\value{
Data frame with PET results
}
\description{
Implements the Precision-Effect Test for publication bias correction.
PET regresses effect sizes against standard errors to test for and correct
publication bias. The intercept represents the bias-corrected effect size
estimate. See
\insertCite{stanley2014meta;textual}{PublicationBiasBenchmark} for details.
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply PET method
result <- run_method("PET", data)
print(result)

}
\references{
\insertAllCited{}
}
