% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QvalBeta.R
\name{parallel_iter}
\alias{parallel_iter}
\title{A tool for the \eqn{\beta} Method}
\usage{
parallel_iter(
  i,
  Y,
  criter.index,
  P.alpha.Xi,
  P.alpha,
  pattern,
  ri,
  Ni,
  Q.pattern.ini,
  model,
  criter,
  search.method,
  P_GDINA,
  Q.beta,
  L,
  K,
  alpha.P,
  get.MLRlasso
)
}
\arguments{
\item{i}{An integer indicating the item number that needs to be validated.}

\item{Y}{A matrix of observed data used for validation.}

\item{criter.index}{An integer representing the index of the criterion.}

\item{P.alpha.Xi}{A matrix representing individual posterior probability.}

\item{P.alpha}{A vector of attribute prior weights.}

\item{pattern}{A matrix representing the attribute mastery patterns.}

\item{ri}{A vector containing the number of examinees in each knowledge state who correctly answered item \eqn{i}.}

\item{Ni}{A vector containing the total number of examinees in each knowledge state.}

\item{Q.pattern.ini}{An integer representing the initial pattern order for the model.}

\item{model}{A model object used for fitting, such as the GDINA model.}

\item{criter}{A character string specifying the fit criterion. Possible values are "AIC", "BIC", "CAIC", or "SABIC".}

\item{search.method}{A character string specifying the search method for model selection. Options include "beta", "ESA", "SSA", or "PAA".}

\item{P_GDINA}{A function that calculates probabilities for the GDINA model.}

\item{Q.beta}{A Q-matrix used for validation.}

\item{L}{An integer representing the number of all attribute mastery patterns.}

\item{K}{An integer representing the number of attributes.}

\item{alpha.P}{A matrix of individuals' marginal mastery probabilities (Tu et al., 2022).}

\item{get.MLRlasso}{A function for Lasso regression with multiple linear regression.}
}
\value{
A \code{list} containing the following components:
\describe{
  \item{fit.index.pre}{The previous fit index value after applying the selected search method.}
  \item{fit.index.cur}{The current fit index value after applying the selected search method.}
  \item{Q.pattern.cur}{The pattern that corresponds to the optimal model configuration for the current iteration.}
  \item{priority}{The priority vector used in the PAA method, if applicable.}
}
}
\description{
This function performs a single iteration of the \eqn{\beta} method for one item's validation. It is designed 
to be used in parallel computing environments to speed up the validation process of the \eqn{\beta} method. 
The function is a utility function for \code{\link[Qval]{validation}}.
When the user calls the \code{\link[Qval]{validation}} function with \code{method = "beta"},  
\code{\link[Qval]{parallel_iter}} runs automatically, so there is no need for the user to call \code{\link[Qval]{parallel_iter}}.
It may seem that \code{\link[Qval]{parallel_iter}}, as an internal function, could better serve users.  
However, we found that the \code{Qval} package must export it to resolve variable environment conflicts in R  
and enable parallel computation. Perhaps a better solution will be found in the future.
}
