% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gompertz.R
\name{calc_gompertz_parameters}
\alias{calc_gompertz_parameters}
\title{Calculating Gompertz model parameters}
\usage{
calc_gompertz_parameters(
  mortality_rates,
  current_age,
  estimate_max_age = FALSE
)
}
\arguments{
\item{mortality_rates}{A data frame
with columns \code{mortality_rate} and \code{age}.
Usually the output of \code{\link[=read_hmd_life_tables]{read_hmd_life_tables()}} function or
filtered data from \link{life_tables} object.}

\item{current_age}{A numeric. Current age.}

\item{estimate_max_age}{A logical. Should the maximum age be estimated?}
}
\value{
A list containing:
\item{data}{The input mortality rates data frame with additional columns like 'survival_rate' and 'probability_of_death'}
\item{mode}{The mode of the Gompertz distribution}
\item{dispersion}{The dispersion parameter of the Gompertz distribution}
\item{current_age}{The current age parameter}
\item{max_age}{The maximum age parameter}
}
\description{
Calculating Gompertz model parameters
}
\examples{
mortality_rates <- 
  dplyr::filter(
    life_tables,
    country == "USA" & 
    sex     == "male" &
    year    == 2022
  )
  
calc_gompertz_parameters(
  mortality_rates = mortality_rates,
  current_age     = 65
)
}
\references{
Blanchet, David M., and Paul D. Kaplan. 2013. "Alpha, Beta, and Now... Gamma." Journal of Retirement 1 (2): 29-45. \doi{10.3905/jor.2013.1.2.029}.
}
