% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_portfolio.R
\name{calc_portfolio_parameters}
\alias{calc_portfolio_parameters}
\title{Calculate Portfolio Parameters}
\usage{
calc_portfolio_parameters(portfolio)
}
\arguments{
\item{portfolio}{A \code{tibble} of class \code{Portfolio}.
Usually created using \code{create_portfolio_template} and customised.}
}
\value{
A list with the following elements:
\itemize{
\item \code{value}: The value of the portfolio.
\item \code{weights}: The weights of assets in the portfolio.
\item \code{expected_return}: The expected return of the portfolio.
\item \code{standard_deviation}: The standard deviation of the portfolio.
}
}
\description{
Calculate Portfolio Parameters
}
\examples{
 portfolio <- create_portfolio_template()
 portfolio$accounts$taxable <- c(10000, 30000)
 calc_portfolio_parameters(portfolio)
}
