% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_SNE.R
\name{do.sne}
\alias{do.sne}
\title{Stochastic Neighbor Embedding}
\usage{
do.sne(
  X,
  ndim = 2,
  perplexity = 30,
  eta = 0.05,
  maxiter = 2000,
  jitter = 0.3,
  jitterdecay = 0.99,
  momentum = 0.5,
  pca = TRUE,
  pcascale = FALSE,
  symmetric = FALSE
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{perplexity}{desired level of perplexity; ranging [5,50].}

\item{eta}{learning parameter.}

\item{maxiter}{maximum number of iterations.}

\item{jitter}{level of white noise added at the beginning.}

\item{jitterdecay}{decay parameter in \eqn{(0,1)}. The closer to 0, the faster artificial noise decays.}

\item{momentum}{level of acceleration in learning.}

\item{pca}{whether to use PCA as preliminary step; \code{TRUE} for using it, \code{FALSE} otherwise.}

\item{pcascale}{a logical; \code{FALSE} for using Covariance, \code{TRUE} for using Correlation matrix. See also \code{\link{do.pca}} for more details.}

\item{symmetric}{a logical; \code{FALSE} to solve it naively, and \code{TRUE} to adopt symmetrization scheme.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{vars}{a vector containing betas used in perplexity matching.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Stochastic Neighbor Embedding (SNE) is a probabilistic approach to mimick distributional
description in high-dimensional - possible, nonlinear - subspace on low-dimensional target space.
\code{do.sne} fully adopts algorithm details in an original paper by Hinton and Roweis (2002).
}
\examples{
\donttest{
## load iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## try different perplexity values
out1 <- do.sne(X, perplexity=5)
out2 <- do.sne(X, perplexity=25)
out3 <- do.sne(X, perplexity=50)

## Visualize two comparisons
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=label, main="perplexity=5")
plot(out2$Y, pch=19, col=label, main="perplexity=25")
plot(out3$Y, pch=19, col=label, main="perplexity=50")
par(opar)
}

}
\references{
\insertRef{hinton_stochastic_2003}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
