% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss_time_series.R
\name{wtss_to_ts}
\alias{wtss_to_ts}
\title{Export data to be used to the ts format}
\usage{
wtss_to_ts(data, band = NULL, period = "week")
}
\arguments{
\item{data}{A sits tibble with time series.}

\item{band}{Name of the band to be exported 
(optional if series has only one band)}

\item{period}{One of c("month", "week", "day"), 
c("months", "weeks", "days") or
c(12, 52, 365)}
}
\value{
A time series in the ts format.
}
\description{
Converts data from a wtss tibble to a time series "ts".
A WTSS tibble contains data retrieved from a WTSS server. 
These data sets are time series with irregular intervals. Given that
of many functions that use the R "ts" format, this function converts 
a time series (a tibble with data and metadata) to the "ts" format. 
Since  "ts" requires regular time series, it interpolates 
the original irregular time series to a regular time series. To do this, the 
user needs to specify a period which is recognised by the "ts" format. 
This period can be either {"month", "week", "day"}, 
{"months", "weeks", "days"} or
{12, 52, 365}. This function creates a new time series with the required 
frequency and intepolates the missing values using spline interpolation 
from the "zoo" package (zoo::na.spline).
}
\examples{
\dontrun{
# connect to a WTSS server
wtss_service <- "https://brazildatacube.dpi.inpe.br/wtss/"
# retrieve a time series
ts_wtss  <- Rwtss::time_series(
                 wtss_service,
                 "MOD13Q1-6", 
                 c("NDVI","EVI"),
                 longitude = -45.00, 
                 latitude  = -12.00,
                 start_date = "2000-02-18", 
                 end_date = "2016-12-18",
                 token = "YOUR-BDC-TOKEN")
# convert to ts
ts <- Rwtss::wtss_to_ts(ts_wtss, band = "NDVI")
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
