% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyntaxa_api_functions.R
\name{update_dyntaxa_taxonomy}
\alias{update_dyntaxa_taxonomy}
\title{Update SHARK taxonomy records using Dyntaxa}
\usage{
update_dyntaxa_taxonomy(
  dyntaxa_ids,
  subscription_key = Sys.getenv("DYNTAXA_KEY"),
  add_missing_taxa = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{dyntaxa_ids}{A vector of Dyntaxa taxon IDs to update.}

\item{subscription_key}{A Dyntaxa API subscription key. By default, the key
is read from the environment variable \code{DYNTAXA_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{update_dyntaxa_taxonomy(238366, subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(DYNTAXA_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{DYNTAXA_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}

\item{add_missing_taxa}{Logical. If TRUE, the function will attempt to fetch missing taxa (i.e., taxon_ids not found in the initial Dyntaxa DwC-A query). Default is FALSE.}

\item{verbose}{Logical. Print progress messages. Default is TRUE.}
}
\value{
A data frame representing the updated Dyntaxa taxonomy table.
}
\description{
This function updates Dyntaxa taxonomy records based on a list of Dyntaxa taxon IDs.
It collects parent IDs from SLU Artdatabanken API (Dyntaxa), retrieves full taxonomy records, and organizes
the data into a full taxonomic table that can be joined with data downloaded from \href{https://shark.smhi.se/en/}{SHARK}
}
\details{
A valid Dyntaxa API subscription key is required.
You can request a free key for the "Taxonomy" service from the ArtDatabanken API portal:
\url{https://api-portal.artdatabanken.se/}

\strong{Note}: Please review the \href{https://www.slu.se/artdatabanken/rapportering-och-fynd/oppna-data-och-apier/}{API conditions}
and \href{https://api-portal.artdatabanken.se/}{register for access} before using the API. Data collected through the API
is stored at SLU Artdatabanken. Please also note that the authors of \code{SHARK4R} are not affiliated with SLU Artdatabanken.
}
\examples{
\dontrun{
# Update Dyntaxa taxonomy for taxon IDs 238366 and 1010380
updated_taxonomy <- update_dyntaxa_taxonomy(c(238366, 1010380), "your_subscription_key")
print(updated_taxonomy)
}


}
\seealso{
\code{\link{get_shark_data}}, \code{\link{update_worms_taxonomy}}, \href{https://api-portal.artdatabanken.se/}{SLU Artdatabanken API Documentation}
}
