% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{sampleDMC}
\alias{sampleDMC}
\title{Sample discrete Markov chains}
\usage{
sampleDMC(pInit, Q, n = 1)
}
\arguments{
\item{pInit}{an array of length K, containing the marginal distribution of the states for the first variable.}

\item{Q}{an array of size (p-1,K,K), containing a list of p-1 transition matrices between the K states of the Markov chain.}

\item{n}{the number of independent samples to be drawn (default: 1).}
}
\value{
A matrix of size n-by-p containing the n observed Markov chains of length p.
}
\description{
This function draws independent random samples of a discrete Markov chain.
}
\details{
Each element of the output matrix is an integer value between 0 and K-1.
The transition matrices contained in Q are defined such that \eqn{P[X_{j+1}=k|X_{j}=l]=Q[j,l,k]}.
}
\examples{
p=10; K=5;
pInit = rep(1/K,K)
Q = array(stats::runif((p-1)*K*K),c(p-1,K,K))
for(j in 1:(p-1)) { Q[j,,] = Q[j,,] / rowSums(Q[j,,]) }
X = sampleDMC(pInit, Q, n=20)

}
\references{
\insertRef{sesia2019}{SNPknock}
}
\seealso{
Other models: \code{\link{sampleHMM}}
}
\concept{models}
